package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import var;

public class MusicsFixedButtonsList extends FixedButtonsList<Music> implements IIMPSmartRender {
    public static final class_2561 UNKNOWN_PLAYER_TEXT = new class_2588("imp.text.unknownPlayer");

    public MusicsFixedButtonsList(int x, int y, int w, int h, int num, class_2561 name, List<Music> list, PressEntry<Music> onPressEntry) {
        super(x, y, w, h, MusicManagerMonitor.WIDGETS_TEXTURE, 0, 20, 256, 256, num, name, list, n -> new class_2585(n.getName()), onPressEntry);
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, Music item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        drawSmartButtonBox(poseStack, x, y, getOneButtonWidth(), getOneButtonHeight(), this.method_25356(this.isHoveredOrFocused(bnum)));
        var img = item.getImage();
        float sx = 2;

        if (!img.isEmpty()) {
            sx += getOneButtonHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, x + 1, y + 1, getOneButtonHeight() - 2, false);
        }

        drawSmartFixedWidthText(poseStack, new class_2585(item.getName()), x + sx, y + 2, getOneButtonWidth() - sx - 2);
        drawSmartFixedWidthText(poseStack, new class_2585(item.getAuthor()), x + sx, y + 13, 90);
        OERenderUtil.drawPlayerFace(poseStack, item.getOwner(), x + sx, y + 23, 9);
        var pname = OEClientUtil.getPlayerNameByUUID(item.getOwner()).map(n -> (class_2561) new class_2585(n)).orElse(UNKNOWN_PLAYER_TEXT);
        drawSmartFixedWidthText(poseStack, pname, x + sx + 12, y + 24, 90);
        drawSmartFixedWidthText(poseStack, new class_2585(MyPlayListFixedButtonsList.dateFormat.format(new Date(item.getCreateDate()))), x + sx + 88 + 15, y + 24, 90);

    }
}
