package dev.felnull.imp.client.music.loader;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class IMPMusicLoaders {
    protected static final Map<class_2960, IMusicLoader> LOADERS = new LinkedHashMap<>();
    public static final class_2960 LAVA_YOUTUBE = new class_2960(IamMusicPlayer.MODID, "lava_youtube");
    public static final class_2960 YOUTUBE_DOWNLOADER = new class_2960(IamMusicPlayer.MODID, "youtube_downloader");
    public static final class_2960 LAVA_SOUNDCLOUD = new class_2960(IamMusicPlayer.MODID, "lava_soundcloud");
    public static final class_2960 LAVA_HTTP = new class_2960(IamMusicPlayer.MODID, "lava_http");
    // public static final ResourceLocation LAVA_NICONICO = new ResourceLocation(IamMusicPlayer.MODID, "lava_niconico");

    public static void init() {
        registerLoader(YOUTUBE_DOWNLOADER, new YoutubeDownloaderMusicLoader());
        registerLoader(LAVA_YOUTUBE, new LavaPlayerMusicLoader(IMPMusicLoaderTypes.YOUTUBE));
        registerLoader(LAVA_SOUNDCLOUD, new LavaPlayerMusicLoader(IMPMusicLoaderTypes.SOUNDCLOUD));
        registerLoader(LAVA_HTTP, new LavaPlayerMusicLoader(IMPMusicLoaderTypes.HTTP));
        //    registerLoader(LAVA_NICONICO, new LavaPlayerMusicLoader(IMPMusicLoaderTypes.NICONICO));
    }

    public static void registerLoader(class_2960 location, IMusicLoader loader) {
        LOADERS.put(location, loader);
    }

    public static IMusicLoader getLoader(class_2960 location) {
        return LOADERS.get(location);
    }

    public static List<IMusicLoader> getLoaders() {
        return new ArrayList<>(LOADERS.values());
    }
}
