package dev.felnull.imp.client.renderer.item;

import dev.felnull.imp.client.gui.components.MyPlayListFixedButtonsList;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.Date;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_809;

public class CassetteTapeItemRenderer implements BEWLItemRenderer {
    private static final class_310 mc = class_310.method_1551();

    @Override
    public void render(class_1799 itemStack, class_809.class_811 transformType, class_4587 poseStack, class_4597 multiBufferSource, float v, int i, int i1) {
        float par = CassetteTapeItem.getTapePercentage(itemStack);
        class_4588 ivb = multiBufferSource.getBuffer(class_4722.method_24074());

        renderBase(poseStack, ivb, multiBufferSource, itemStack, i, i1);

        class_1087 glassModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_GLASS_MODEL);
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 3, 0, 2.25d);
        OERenderUtil.renderModel(poseStack, ivb, glassModel, i, i1);
        poseStack.method_22909();

        renderTapeRoll(poseStack, par * 10f, 1 - par, ivb, 7.25d, -0.01f, 2.5d, i, i1);
        renderTapeRoll(poseStack, par * 10f, par, ivb, 1.75d, -0.01f, 2.5d, i, i1);

        class_1087 tapeModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_MODEL);
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 0.975d, 0.25d, 0.275d);
        OERenderUtil.renderModel(poseStack, ivb, tapeModel, i, i1);
        poseStack.method_22909();

        renderTapeConecter(poseStack, 22 - 46 * par, ivb, 0.975d, 0.25d, 0.8d, i, i1);
        renderTapeConecter(poseStack, 22 - 46 * par, ivb, 9d, 0.25d, 0.8d, i, i1);

        renderMusicInfo(poseStack, ivb, multiBufferSource, itemStack, i, i1);
    }

    private static void renderMusicInfo(class_4587 poseStack, class_4588 ivb, class_4597 multiBufferSource, class_1799 stack, int i, int i1) {

        Music music = CassetteTapeItem.getMusic(stack);

        if (music == null)
            return;

        class_1087 labelModel = OEModelUtil.getModel(music.getImage().isEmpty() ? IMPModels.CASSETTE_TAPE_LABEL_NO_IMAGE_MODEL : IMPModels.CASSETTE_TAPE_LABEL_MODEL);
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 3d, 1d, 4d);
        OERenderUtil.renderModel(poseStack, ivb, labelModel, i, i1);
        poseStack.method_22904(0, (1f / 16f) * 0.025f + OERenderUtil.MIN_BREADTH, 0);

        if (!music.getImage().isEmpty()) {
            float size = (1f / 16f) * 1.025f;
            float x = 2.8f;
            float y = 0.55f;
            poseStack.method_22903();
            OERenderUtil.poseRotateAll(poseStack, -90, 0, 180);
            PlayImageRenderer.getInstance().renderSprite(music.getImage(), poseStack, multiBufferSource, -(size + (1f / 16f) * x), (1f / 16f) * y, 0, size, i, i1);
            poseStack.method_22909();
        }

        poseStack.method_22903();
        OERenderUtil.poseRotateX(poseStack, 90f);
        OERenderUtil.poseRotateY(poseStack, 180);
        float x = music.getImage().isEmpty() ? 3.85f : 2.65f;
        OERenderUtil.renderTextSprite(poseStack, multiBufferSource, new class_2585(MyPlayListFixedButtonsList.dateFormat.format(new Date(music.getCreateDate()))), -(1f / 16f) * 3.85f, (1f / 16f) * 0.18f, 0, 0.15f, 0, 0, i);
        class_2561 namec = new class_2585(music.getName());
        int ms = music.getImage().isEmpty() ? 120 : 80;
        String dot = "...";
        if (mc.field_1772.method_27525(namec) >= ms) {
            StringBuilder sb = new StringBuilder();
            for (char c : music.getName().toCharArray()) {
                sb.append(c);
                if (mc.field_1772.method_1727(sb.toString()) >= ms - mc.field_1772.method_1727(dot)) {
                    sb.deleteCharAt(sb.length() - 1);
                    break;
                }
            }
            sb.append(dot);
            namec = new class_2585(sb.toString());
        }
        OERenderUtil.renderTextSprite(poseStack, multiBufferSource, namec, -(1f / 16f) * x, (1f / 16f) * 1.2f, 0, 0.18f, 0, 0, i);
        class_2561 authorc = new class_2585(music.getAuthor());
        if (mc.field_1772.method_27525(authorc) >= ms) {
            StringBuilder sb = new StringBuilder();
            for (char c : music.getAuthor().toCharArray()) {
                sb.append(c);
                if (mc.field_1772.method_1727(sb.toString()) >= ms - mc.field_1772.method_1727(dot)) {
                    sb.deleteCharAt(sb.length() - 1);
                    break;
                }
            }
            sb.append(dot);
            authorc = new class_2585(sb.toString());
        }
        OERenderUtil.renderTextSprite(poseStack, multiBufferSource, authorc, -(1f / 16f) * x, (1f / 16f) * 0.575f, 0, 0.18f, 0, 0, i);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static void renderBase(class_4587 poseStack, class_4588 ivb, class_4597 multiBufferSource, class_1799 stack, int i, int i1) {
        if (stack.method_7909() instanceof CassetteTapeItem) {
            CassetteTapeItem.BaseType type = ((CassetteTapeItem) stack.method_7909()).getType();
            class_2960 location = IMPModels.CASSETTE_TAPE_BASE_NORMAL_MODEL;
            int color = ((CassetteTapeItem) stack.method_7909()).method_7801(stack) ? ((CassetteTapeItem) stack.method_7909()).method_7800(stack) : 0x1a1a1a;
            if (type == CassetteTapeItem.BaseType.GLASS) {
                location = ((CassetteTapeItem) stack.method_7909()).method_7801(stack) ? IMPModels.CASSETTE_TAPE_BASE_GLASS_COLOR_MODEL : IMPModels.CASSETTE_TAPE_BASE_GLASS_MODEL;
                ivb = multiBufferSource.getBuffer(class_4722.method_24076());
            }
            class_1087 bakedModel = OEModelUtil.getModel(location);
            OERenderUtil.renderModel(poseStack, ivb, bakedModel, i, i1, color);
        }
    }

    private static void renderTapeConecter(class_4587 poseStack, float angle, class_4588 ivb, double x, double y, double z, int i, int i1) {
        class_1087 tapeConecterModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_CONECTER);
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, x, y, z);
        float f = 0.025f / 2f;
        OERenderUtil.poseTrans16(poseStack, f, f, f);
        OERenderUtil.poseRotateY(poseStack, angle);
        OERenderUtil.poseTrans16(poseStack, -f, -f, -f);
        OERenderUtil.renderModel(poseStack, ivb, tapeConecterModel, i, i1);
        poseStack.method_22909();
    }

    private static void renderTapeRoll(class_4587 poseStack, float par, float roll, class_4588 ivb, double x, double y, double z, int i, int i1) {
        roll = class_3532.method_15363(roll, 0, 1);
        class_1087 tapeCoreModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_CORE_MODEL);
        class_1087 tapeCoreAroundModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_CORE_AROUND_MODEL);
        class_1087 tapeRollModel = OEModelUtil.getModel(IMPModels.CASSETTE_TAPE_ROLL_MODEL);

        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, x, y, z);
        poseStack.method_22905(1.25f, 1.05f, 1.25f);
        OERenderUtil.poseTrans16(poseStack, 0.4, 0, 0.4);
        OERenderUtil.poseRotateY(poseStack, par * 360f);
        OERenderUtil.poseTrans16(poseStack, -0.4, 0, -0.4);
        OERenderUtil.renderModel(poseStack, ivb, tapeCoreModel, i, i1);
        OERenderUtil.poseTrans16(poseStack, 0, 0.25, 0);
        OERenderUtil.renderModel(poseStack, ivb, tapeCoreAroundModel, i, i1);
        OERenderUtil.poseTrans16(poseStack, 0, 0.125f / 2f, 0);
        float rollPar = roll + 0.5f;
        for (int j = 1; j <= Math.ceil(rollPar); j++) {
            poseStack.method_22903();
            OERenderUtil.poseTrans16(poseStack, 0.4, 0, 0.4);
            float sc = Math.min(rollPar, j);
            poseStack.method_22905(sc, 1, sc);
            OERenderUtil.poseTrans16(poseStack, -0.4, 0, -0.4);
            OERenderUtil.renderModel(poseStack, ivb, tapeRollModel, i, i1);
            poseStack.method_22909();
        }

        poseStack.method_22909();
    }

}
