/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.BaseYoutubeHttpContextFilter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.org.apache.commons.codec.digest.DigestUtils;
import dev.felnull.imp.include.org.apache.http.HttpResponse;
import dev.felnull.imp.include.org.apache.http.client.CookieStore;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.impl.client.BasicCookieStore;

public class YoutubeHttpContextFilter
extends BaseYoutubeHttpContextFilter {
    public static final String PBJ_PARAMETER = "&pbj=1";
    private static final String ATTRIBUTE_RESET_RETRY = "isResetRetry";
    private static String PAPISID = "";
    private static String PSID = "";

    public static void setPAPISID(String value) {
        PAPISID = value;
    }

    public static void setPSID(String value) {
        PSID = value;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            context.setCookieStore(cookieStore);
        }
        cookieStore.clear();
    }

    @Override
    public void onContextClose(HttpClientContext context) {
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        if (!isRepetition) {
            context.removeAttribute(ATTRIBUTE_RESET_RETRY);
        }
        if (this.isPbjRequest(request)) {
            this.addPbjHeaders(request);
        }
        if (!PAPISID.isEmpty() && !PSID.isEmpty()) {
            long millis = System.currentTimeMillis();
            String SAPISIDHASH = DigestUtils.sha1Hex(millis + " " + PAPISID + " " + "https://www.youtube.com");
            request.setHeader("Cookie", "__Secure-3PAPISID=" + PAPISID + " __Secure-3PSID=" + PSID);
            request.setHeader("Origin", "https://www.youtube.com");
            request.setHeader("Authorization", "SAPISIDHASH " + millis + "_" + SAPISIDHASH);
        }
        super.onRequest(context, request, isRepetition);
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        if (response.getStatusLine().getStatusCode() == 429) {
            throw new FriendlyException("This IP address has been blocked by YouTube (429).", FriendlyException.Severity.COMMON, null);
        }
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (HttpClientTools.isConnectionResetException(error) && context.getAttribute(ATTRIBUTE_RESET_RETRY) == null) {
            context.setAttribute(ATTRIBUTE_RESET_RETRY, true);
            return true;
        }
        return false;
    }

    protected boolean isPbjRequest(HttpUriRequest request) {
        String rawQuery = request.getURI().getRawQuery();
        return rawQuery != null && rawQuery.contains(PBJ_PARAMETER);
    }

    protected void addPbjHeaders(HttpUriRequest request) {
        request.setHeader("user-agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.100 Safari/537.36");
        request.setHeader("x-youtube-client-name", "1");
        request.setHeader("x-youtube-client-version", "2.20191008.04.01");
        request.setHeader("x-youtube-page-cl", "276511266");
        request.setHeader("x-youtube-page-label", "youtube.ytfe.desktop_20191024_3_RC0");
        request.setHeader("x-youtube-utc-offset", "0");
        request.setHeader("x-youtube-variants-checksum", "7a1198276cf2b23fc8321fac72aa876b");
        request.setHeader("accept-language", "en");
    }
}

