/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.common.AacPacketRouter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAacTrackConsumer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import dev.felnull.imp.include.net.sourceforge.jaad.aac.Decoder;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.nio.ByteBuffer;

public class MatroskaAacTrackConsumer
implements MatroskaTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MatroskaFileTrack track;
    private final AacPacketRouter packetRouter;
    private ByteBuffer inputBuffer;
    private boolean configured;

    public MatroskaAacTrackConsumer(AudioProcessingContext context, MatroskaFileTrack track) {
        this.track = track;
        this.packetRouter = new AacPacketRouter(context);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with expected frequency {} and channel count {}.", (Object)Float.valueOf(this.track.audio.samplingFrequency), (Object)this.track.audio.channels);
    }

    @Override
    public MatroskaFileTrack getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.packetRouter.seekPerformed(requestedTimecode, providedTimecode);
    }

    @Override
    public void flush() throws InterruptedException {
        this.packetRouter.flush();
    }

    @Override
    public void consume(ByteBuffer data) throws InterruptedException {
        if (this.packetRouter.nativeDecoder == null) {
            this.packetRouter.nativeDecoder = new AacDecoder();
            this.configured = this.configureDecoder(this.packetRouter.nativeDecoder);
        }
        if (this.configured) {
            if (this.inputBuffer == null) {
                this.inputBuffer = ByteBuffer.allocateDirect(4096);
            }
            this.processInput(data);
        } else {
            if (this.packetRouter.embeddedDecoder == null) {
                this.packetRouter.embeddedDecoder = Decoder.create(this.track.codecPrivate);
                this.inputBuffer = ByteBuffer.allocate(4096);
            }
            this.processInput(data);
        }
    }

    private void processInput(ByteBuffer data) throws InterruptedException {
        while (data.hasRemaining()) {
            int chunk = Math.min(data.remaining(), this.inputBuffer.capacity());
            ByteBuffer chunkBuffer = data.duplicate();
            chunkBuffer.limit(chunkBuffer.position() + chunk);
            this.inputBuffer.clear();
            this.inputBuffer.put(chunkBuffer);
            this.inputBuffer.flip();
            this.packetRouter.processInput(this.inputBuffer);
            data.position(chunkBuffer.position());
        }
    }

    @Override
    public void close() {
        this.packetRouter.close();
    }

    private boolean configureDecoder(AacDecoder decoder) {
        return decoder.configure(this.track.codecPrivate) == 0;
    }
}

