/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggPageHeader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggPageScanner;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggSeekPoint;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.StreamTools;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class OggPacketInputStream
extends InputStream {
    static final int[] OGG_PAGE_HEADER = new int[]{79, 103, 103, 83};
    private static final int SHORT_SCAN = 10240;
    private static final int LONG_SCAN = 65307;
    private final SeekableInputStream inputStream;
    private final boolean closeDelegated;
    private final DataInput dataInput;
    private final int[] segmentSizes;
    private List<OggSeekPoint> seekPoints;
    private OggPageHeader pageHeader;
    private int bytesLeftInPacket;
    private boolean packetContinues;
    private int nextPacketSegmentIndex;
    private State state;

    public OggPacketInputStream(SeekableInputStream inputStream, boolean closeDelegated) {
        this.inputStream = inputStream;
        this.closeDelegated = closeDelegated;
        this.dataInput = new DataInputStream(inputStream);
        this.segmentSizes = new int[256];
        this.state = State.TRACK_BOUNDARY;
    }

    public void setSeekPoints(List<OggSeekPoint> seekPoints) {
        this.seekPoints = seekPoints;
    }

    public boolean startNewTrack() {
        if (this.state == State.TERMINATED) {
            return false;
        }
        if (this.state != State.TRACK_BOUNDARY) {
            throw new IllegalStateException("Cannot load the next track while the previous one has not been consumed.");
        }
        this.pageHeader = null;
        this.state = State.PACKET_BOUNDARY;
        return true;
    }

    public boolean startNewPacket() throws IOException {
        if (this.state == State.TRACK_BOUNDARY) {
            return false;
        }
        if (this.state == State.TRACK_SEEKING) {
            this.loadNextNonEmptyPage();
        } else if (this.state != State.PACKET_BOUNDARY) {
            throw new IllegalStateException("Cannot start a new packet while the previous one has not been consumed.");
        }
        if (!(this.pageHeader != null && this.nextPacketSegmentIndex != this.pageHeader.segmentCount || this.loadNextNonEmptyPage())) {
            return false;
        }
        if (!this.initialisePacket()) {
            return this.loadNextNonEmptyPage();
        }
        return true;
    }

    public boolean isPacketComplete() {
        return this.state == State.PACKET_READ;
    }

    private boolean readPageHeader() throws IOException {
        if (!MediaContainerDetection.checkNextBytes(this.inputStream, OGG_PAGE_HEADER, false)) {
            if (this.inputStream.read() == -1) {
                return false;
            }
            throw new IllegalStateException("Stream is not positioned at a page header.");
        }
        if ((this.dataInput.readByte() & 0xFF) != 0) {
            throw new IllegalStateException("Unknown OGG stream version.");
        }
        int flags = this.dataInput.readByte() & 0xFF;
        long position = Long.reverseBytes(this.dataInput.readLong());
        int streamIdentifier = Integer.reverseBytes(this.dataInput.readInt());
        int pageSequence = Integer.reverseBytes(this.dataInput.readInt());
        int checksum = Integer.reverseBytes(this.dataInput.readInt());
        int segmentCount = this.dataInput.readByte() & 0xFF;
        long byteStreamPosition = this.inputStream.getPosition() - 27L;
        this.pageHeader = new OggPageHeader(flags, position, streamIdentifier, pageSequence, checksum, segmentCount, byteStreamPosition);
        for (int i = 0; i < segmentCount; ++i) {
            this.segmentSizes[i] = this.dataInput.readByte() & 0xFF;
        }
        return true;
    }

    private boolean loadNextNonEmptyPage() throws IOException {
        do {
            if (this.loadNextPage()) continue;
            return false;
        } while (this.pageHeader.segmentCount == 0);
        return true;
    }

    private boolean loadNextPage() throws IOException {
        if (this.pageHeader != null && this.pageHeader.isLastPage) {
            if (this.packetContinues) {
                throw new IllegalStateException("Track finished in the middle of a packet.");
            }
            this.state = State.TRACK_BOUNDARY;
            return false;
        }
        if (!this.readPageHeader()) {
            if (this.packetContinues) {
                throw new IllegalStateException("Stream ended in the middle of a packet.");
            }
            return false;
        }
        this.nextPacketSegmentIndex = 0;
        this.state = State.PACKET_READ;
        return true;
    }

    private boolean initialisePacket() {
        while (this.nextPacketSegmentIndex < this.pageHeader.segmentCount) {
            int size = this.segmentSizes[this.nextPacketSegmentIndex++];
            this.bytesLeftInPacket += size;
            if (size >= 255) continue;
            if (this.bytesLeftInPacket == 0) {
                this.state = State.PACKET_BOUNDARY;
                return false;
            }
            this.packetContinues = false;
            return true;
        }
        this.packetContinues = true;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeftInPacket == 0) {
            return -1;
        }
        int value = this.inputStream.read();
        if (value == -1) {
            return -1;
        }
        if (--this.bytesLeftInPacket == 0) {
            this.continuePacket();
        }
        return value;
    }

    @Override
    public int read(byte[] buffer, int initialOffset, int length) throws IOException {
        int currentOffset = initialOffset;
        int maximumOffset = initialOffset + length;
        while (currentOffset < maximumOffset) {
            if (this.bytesLeftInPacket == 0) {
                return -1;
            }
            int chunk = Math.min(maximumOffset - currentOffset, this.bytesLeftInPacket);
            int read = this.inputStream.read(buffer, currentOffset, chunk);
            if (read == -1) {
                throw new EOFException("Underlying stream ended before the end of a packet.");
            }
            currentOffset += read;
            this.bytesLeftInPacket -= read;
            if (!(this.bytesLeftInPacket == 0 ? !this.continuePacket() : read < chunk)) continue;
            break;
        }
        return currentOffset - initialOffset;
    }

    @Override
    public int available() throws IOException {
        if (this.state != State.PACKET_READ) {
            return 0;
        }
        return Math.min(this.inputStream.available(), this.bytesLeftInPacket);
    }

    @Override
    public void close() throws IOException {
        if (this.closeDelegated) {
            this.inputStream.close();
        }
    }

    public long seek(long timecode) throws IOException {
        if (this.seekPoints == null) {
            throw new IllegalStateException("Seek points have not been set.");
        }
        int low = 0;
        int mid = 0;
        int high = this.seekPoints.size() - 1;
        while (low <= high) {
            mid = (low + high) / 2;
            if (this.seekPoints.get(mid).getTimecode() <= timecode) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        mid = mid > 0 ? --mid : ++mid;
        OggSeekPoint seekPoint = this.seekPoints.get(mid);
        this.inputStream.seek(seekPoint.getPosition());
        this.state = State.TRACK_SEEKING;
        return seekPoint.getTimecode();
    }

    public List<OggSeekPoint> createSeekTable(int sampleRate) throws IOException {
        if (!this.inputStream.canSeekHard()) {
            return null;
        }
        long savedPosition = this.inputStream.getPosition();
        long absoluteOffset = this.pageHeader.byteStreamPosition;
        this.inputStream.seek(absoluteOffset);
        byte[] data = new byte[(int)this.inputStream.getContentLength()];
        int dataLength = StreamTools.readUntilEnd(this.inputStream, data, 0, data.length);
        List<OggSeekPoint> seekPoints = new OggPageScanner(absoluteOffset, data, dataLength).createSeekTable(sampleRate);
        this.inputStream.seek(savedPosition);
        return seekPoints;
    }

    public OggStreamSizeInfo seekForSizeInfo(int sampleRate) throws IOException {
        if (!this.inputStream.canSeekHard()) {
            return null;
        }
        long savedPosition = this.inputStream.getPosition();
        OggStreamSizeInfo sizeInfo = this.scanForSizeInfo(10240, sampleRate);
        if (sizeInfo == null) {
            sizeInfo = this.scanForSizeInfo(65307, sampleRate);
        }
        this.inputStream.seek(savedPosition);
        return sizeInfo;
    }

    private OggStreamSizeInfo scanForSizeInfo(int tailLength, int sampleRate) throws IOException {
        if (this.pageHeader == null) {
            return null;
        }
        long absoluteOffset = Math.max(this.pageHeader.byteStreamPosition, this.inputStream.getContentLength() - (long)tailLength);
        this.inputStream.seek(absoluteOffset);
        byte[] data = new byte[tailLength];
        int dataLength = StreamTools.readUntilEnd(this.inputStream, data, 0, data.length);
        return new OggPageScanner(absoluteOffset, data, dataLength).scanForSizeInfo(this.pageHeader.byteStreamPosition, sampleRate);
    }

    private boolean continuePacket() throws IOException {
        if (!this.packetContinues) {
            this.state = State.PACKET_BOUNDARY;
            return false;
        }
        if (!this.loadNextNonEmptyPage()) {
            throw new IllegalStateException("Track or stream end reached within an incomplete packet.");
        }
        return this.initialisePacket();
    }

    private static enum State {
        TRACK_SEEKING,
        TRACK_BOUNDARY,
        PACKET_BOUNDARY,
        PACKET_READ,
        TERMINATED;

    }
}

