/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.org.apache.http.Header;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpHead;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class SoundCloudHelper {
    public static String nonMobileUrl(String url) {
        if (url.startsWith("https://m.")) {
            return "https://" + url.substring("https://m.".length());
        }
        return url;
    }

    public static String loadPlaybackUrl(HttpInterface httpInterface, String jsonUrl) throws IOException {
        try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, URI.create(jsonUrl), null);){
            if (!HttpClientTools.isSuccessWithContent(stream.checkStatusCode())) {
                throw new IOException("Invalid status code for soundcloud stream: " + stream.checkStatusCode());
            }
            JsonBrowser json = JsonBrowser.parse(stream);
            String string = json.get("url").text();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AudioReference redirectMobileLink(HttpInterface httpInterface, AudioReference reference) {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(reference.identifier));){
            HttpClientTools.assertSuccessWithContent(response, "mobile redirect response");
            HttpClientContext context = httpInterface.getContext();
            List<URI> redirects = context.getRedirectLocations();
            if (redirects != null && !redirects.isEmpty()) {
                AudioReference audioReference = new AudioReference(redirects.get(0).toString(), null);
                return audioReference;
            }
            throw new FriendlyException("Unable to process soundcloud mobile link", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected soundcloud to redirect soundcloud.app.goo.gl link to a valid track/playlist link, but it did not redirect at all"));
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AudioReference resolveShortTrackUrl(HttpInterface httpInterface, AudioReference reference) {
        HttpHead request = new HttpHead(reference.identifier);
        request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            Header header = response.getLastHeader("Location");
            if (header == null) {
                throw new FriendlyException("Unable to resolve Soundcloud short URL", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Unable to locate canonical URL"));
            }
            AudioReference audioReference = new AudioReference(header.getValue(), null);
            return audioReference;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions(e);
        }
    }
}

