package dev.felnull.imp.blockentity;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class IMPBlockEntities {
    private static final DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES_REGISTER = DeferredRegister.create(OtyacraftEngine.MODID, class_2378.field_25073);
    public static final RegistrySupplier<class_2591<MusicManagerBlockEntity>> MUSIC_MANAGER = register("music_manager", MusicManagerBlockEntity::new, IMPBlocks.MUSIC_MANAGER);
    public static final RegistrySupplier<class_2591<CassetteDeckBlockEntity>> CASSETTE_DECK = register("cassette_deck", CassetteDeckBlockEntity::new, IMPBlocks.CASSETTE_DECK);
    public static final RegistrySupplier<class_2591<BoomboxBlockEntity>> BOOMBOX = register("boombox", BoomboxBlockEntity::new, IMPBlocks.BOOMBOX);

    private static <T extends class_2586> RegistrySupplier<class_2591<T>> register(String name, class_2591.class_5559<T> constructor, RegistrySupplier<class_2248> blocks) {
        return BLOCK_ENTITY_TYPES_REGISTER.register(name, () -> class_2591.class_2592.method_20528(constructor, blocks.get()).method_11034(null));
    }

    public static void init() {
        BLOCK_ENTITY_TYPES_REGISTER.register();
    }
}
