package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class RemoteMusicsFixedListWidget extends MusicsFixedListWidget {
    public RemoteMusicsFixedListWidget(int x, int y, List<Music> list, PressEntry<Music> onPressEntry, @Nullable RemoteMusicsFixedListWidget old) {
        super(x, y, 129, 35, class_2561.method_43471("imp.fixedList.myMusic"), 5, list, onPressEntry, false, old);
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, Music item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        drawSmartButtonBox(poseStack, bX, bY, getIndividualWidth(), getIndividualHeight(), this.method_25356(this.isEntryHovered(bnum)));

        float sx = 1;
        var img = item.getImage();
        if (!img.isEmpty()) {
            sx += getIndividualHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, bX + 1, bY + 1, getIndividualHeight() - 2);
        }

        poseStack.method_22903();
        float sc = 0.7f;
        OERenderUtils.poseScaleAll(poseStack, sc);
        drawSmartText(poseStack, class_2561.method_43470(OEClientUtils.getWidthOmitText(item.getName(), getIndividualWidth() - sx - 2 + 47, "...")), (bX + sx) / sc, (bY + 1f) / sc);
        poseStack.method_22909();
    }
}
