package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class SearchMusicsFixedListWidget extends IMPBaseFixedListWidget<MusicMediaResult> {
    public SearchMusicsFixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<MusicMediaResult> entryList, @Nullable PressEntry<MusicMediaResult> onPressEntry, @Nullable FixedListWidget<MusicMediaResult> old) {
        super(x, y, width, height, message, entryShowCount, entryList, n -> Component.literal(n.name()), onPressEntry, false, old);
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, MusicMediaResult item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        drawSmartButtonBox(poseStack, bX, bY, getIndividualWidth(), getIndividualHeight(), this.method_25356(this.isEntryHovered(bnum)));
        var img = item.imageInfo();
        float sx = 1;

        if (!img.isEmpty()) {
            sx += getIndividualHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, bX + 1, bY + 1, getIndividualHeight() - 2, false);
        }
        drawSmartFixedWidthText(poseStack, class_2561.method_43470(item.name()), bX + sx, bY + 2, getIndividualWidth() - sx - 2);
        drawSmartFixedWidthText(poseStack, class_2561.method_43470(item.author()), bX + sx, bY + 12, getIndividualWidth() - sx - 2);
    }
}
