package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class SmartButton extends class_4185 implements IIMPSmartRender {
    private boolean center = true;
    private class_2960 iconTexture;
    private int iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight;
    private boolean hideText;

    public SmartButton(int x, int y, int w, int h, class_2561 text, class_4241 onPress, class_5316 onTooltip) {
        super(x, y, w, h, text, onPress, onTooltip);
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public SmartButton(int x, int y, int w, int h, class_2561 text, class_4241 onPress) {
        super(x, y, w, h, text, onPress);
    }

    public void setHideText(boolean hideText) {
        this.hideText = hideText;
    }

    @Override
    public void method_25359(class_4587 poseStack, int mx, int my, float f) {
        drawSmartButtonBox(poseStack, field_22760, field_22761, field_22758, field_22759, this.method_25356(this.method_25367()));
        float fx = center ? (float) (field_22758 - mc.field_1772.method_27525(method_25369())) / 2f : 2;
        float fy = (float) (field_22759 - 7) / 2f;

        if (iconTexture != null) {
            float itx = hideText ? (field_22758 - iconWidth) / 2f : 2;
            float ity = (float) (field_22759 - iconHeight) / 2f;
            fx += itx + iconWidth;
            OERenderUtils.drawTexture(iconTexture, poseStack, field_22760 + itx, field_22761 + ity, iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight);
        }

        if (!hideText)
            drawSmartText(poseStack, method_25369(), field_22760 + fx, field_22761 + fy);

        if (this.method_25367())
            this.method_25352(poseStack, mx, my);
    }

    public void setIcon(class_2960 location, int stX, int stY, int w, int h) {
        setIcon(location, stX, stY, w, h, 256, 256);
    }

    public void setIcon(class_2960 location, int stX, int stY, int w, int h, int texW, int texH) {
        setCenter(false);
        this.iconTexture = location;
        this.iconStX = stX;
        this.iconStY = stY;
        this.iconWidth = w;
        this.iconHeight = h;
        this.textureWidth = texW;
        this.textureHeight = texH;
    }

}
