package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class SortButton extends class_4185 implements IIMPSmartRender {
    protected final boolean longed;

    private SortButton(int x, int y, int w, int tx, class_2561 component, class_4241 onPress, boolean longed, class_437 screen) {
        super(x, y, w, 9, component, onPress, longed ? field_25035 : (button, poseStack, px, py) -> screen.method_25424(poseStack, getText(button), px, py));
        // super(x, y, w, 9, tx, 30, 9, MusicManagerMonitor.WIDGETS_TEXTURE, 256, 256, onPress, longed ? NO_TOOLTIP : (button, poseStack, px, py) -> screen.renderTooltip(poseStack, getText(button), px, py), Component.translatable("imp.button.sort"));
        this.longed = longed;
    }

    private static class_2561 getText(class_4185 button) {
        if (button instanceof SortTypeButton sortButton) {
            return class_2561.method_43471("imp.sortType." + sortButton.getSortType().getName());
        } else if (button instanceof OrderTypeButton orderButton) {
            return class_2561.method_43471("imp.orderType." + orderButton.getOrderType().getName());
        }
        return class_2561.method_43470("none");
    }

    @Override
    public void method_25306() {
        cycle();
        super.method_25306();
    }

    @Override
    public void method_25359(class_4587 poseStack, int mx, int my, float f) {
        drawSmartButtonBox(poseStack, field_22760, field_22761, field_22758, field_22759, method_25367());
        if (this.method_25367())
            this.method_25352(poseStack, mx, my);
    }

    abstract public void cycle();

    public static enum SortType {
        NAME("name", (o1, o2) -> {
            return o1.getCompareName().compareTo(o2.getCompareName());
        }), PLAYER("player", (o1, o2) -> {
            return o1.getComparePlayerName().compareTo(o2.getComparePlayerName());
        }), CREATE_DATE("create_date", (o1, o2) -> (int) (o1.getCompareDate() - o2.getCompareDate()));
        private final String name;
        private final Comparator<IIMPComparable> comparator;
        private final Comparator<IIMPComparable> rcomparator;

        private SortType(String name, Comparator<IIMPComparable> comparator) {
            this.name = name;
            this.comparator = comparator;
            this.rcomparator = comparator.reversed();
        }

        public String getName() {
            return name;
        }

        public Comparator<IIMPComparable> getComparator(OrderType orderType) {
            return orderType.isReverse() ? rcomparator : comparator;
        }

    }

    public static enum OrderType {
        ASCENDING("ascending", false), DESCENDING("descending", true);
        private final String name;
        private final boolean reverse;

        private OrderType(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
        }

        public boolean isReverse() {
            return reverse;
        }

        public String getName() {
            return name;
        }
    }

    public static class SortTypeButton extends SortButton {
        private SortType type = SortType.NAME;

        public SortTypeButton(int x, int y, class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 97 : 9, longed ? 61 : 52, class_2561.method_43471("imp.button.sort"), onPress, longed, screen);
        }

        @Override
        public void cycle() {
            type = SortType.values()[(type.ordinal() + 1) % SortType.values().length];
        }

        public SortType getSortType() {
            return type;
        }

        public <T extends IIMPComparable> List<T> sort(List<T> target, OrderTypeButton orderTypeButton) {
            return target.stream().sorted(getSortType().getComparator(orderTypeButton.getOrderType())).toList();
        }

        @Override
        public void method_25359(class_4587 poseStack, int mx, int my, float f) {
            super.method_25359(poseStack, mx, my, f);
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, field_22760 + 1, field_22761 + 1, 73 + getSortType().ordinal() * 7, 0, 7, 7);
            if (longed) {
                drawSmartText(poseStack, SortButton.getText(this), field_22760 + 9, field_22761 + 1);
            }
        }
    }

    public static class OrderTypeButton extends SortButton {
        private OrderType type = OrderType.DESCENDING;

        public OrderTypeButton(int x, int y, class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 88 : 9, longed ? 158 : 52, class_2561.method_43471("imp.button.order"), onPress, longed, screen);
        }

        @Override
        public void cycle() {
            type = OrderType.values()[(type.ordinal() + 1) % OrderType.values().length];
        }

        public OrderType getOrderType() {
            return type;
        }

        @Override
        public void method_25359(class_4587 poseStack, int mx, int my, float f) {
            super.method_25359(poseStack, mx, my, f);
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, field_22760 + 1, field_22761 + 1, 73 + getOrderType().ordinal() * 7, 7, 7, 7);
            if (longed) {
                drawSmartText(poseStack, SortButton.getText(this), field_22760 + 9, field_22761 + 1);
            }
        }
    }
}
