package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity.MonitorType;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class DeleteBaseMMMonitor extends MusicManagerMonitor {
    private static final class_2561 CANCEL_TEXT = class_2561.method_43471("gui.cancel");
    private static final class_2561 DELETE_TEXT = class_2561.method_43471("imp.button.delete").method_27692(class_124.field_1079);
    private class_2561 WARING;
    private String cashName;

    public DeleteBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.WARING = class_2561.method_43469("imp.text.deleteWarning", getWaringName());
        this.cashName = getWaringName();

        this.addRenderWidget(new SmartButton(getStartX() + 5, getStartY() + 180, 177, 15, DELETE_TEXT, n -> {
            onDelete();
            insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST);
        }));

        this.addRenderWidget(new SmartButton(getStartX() + width - 5 - 177, getStartY() + 180, 177, 15, CANCEL_TEXT, n -> {
            var pare = getParentType();
            if (pare == null)
                pare = MusicManagerBlockEntity.MonitorType.PLAY_LIST;
            insMonitor(pare);
        }));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.cashName.equals(getWaringName())) {
            this.cashName = getWaringName();
            this.WARING = class_2561.method_43469("imp.text.deleteWarning", this.cashName);
        }
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        poseStack.method_22903();
        float sc = Math.min(1f, (width - 20f) / (float) mc.field_1772.method_27525(WARING));
        OERenderUtils.poseScaleAll(poseStack, sc);
        drawSmartCenterText(poseStack, WARING, (getStartX() + (float) width / 2f) / sc, (getStartY() + (float) height / 2f - 16.5f) / sc);
        poseStack.method_22909();
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float) width;
        float onPxH = monitorHeight / (float) height;

        var wrtx = class_2561.method_43469("imp.text.deleteWarning", getWaringName(blockEntity));
        float sc = Math.min(1f, (width - 20f) / (float) mc.field_1772.method_27525(wrtx));
        renderSmartCenterTextSprite(poseStack, multiBufferSource, wrtx, (float) width / 2f, (float) height / 2f - 16.5f, OERenderUtils.MIN_BREADTH * 2, onPxW, onPxH, monitorHeight, sc, i);

        renderSmartButtonSprite(poseStack, multiBufferSource, 5, 180, OERenderUtils.MIN_BREADTH * 3, 177, 15, i, j, onPxW, onPxH, monitorHeight, DELETE_TEXT, true);
        renderSmartButtonSprite(poseStack, multiBufferSource, width - 5 - 177, 180, OERenderUtils.MIN_BREADTH * 3, 177, 15, i, j, onPxW, onPxH, monitorHeight, CANCEL_TEXT, true);
    }

    abstract public void onDelete();

    public String getWaringName() {
        if (getScreen().getBlockEntity() instanceof MusicManagerBlockEntity musicManagerBlockEntity)
            return getWaringName(musicManagerBlockEntity);
        return null;
    }

    @NotNull
    abstract public String getWaringName(MusicManagerBlockEntity musicManagerBlockEntity);
}
