package dev.felnull.imp.client.renderer.blockentity;

import dev.felnull.imp.block.CassetteDeckBlock;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_809;

public class CassetteDeckBlockEntityRenderer extends AbstractBlockEntityRenderer<CassetteDeckBlockEntity> {
    private static final Map<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor> monitors = new HashMap<>();
    private static final class_310 mc = class_310.method_1551();

    protected CassetteDeckBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public void render(CassetteDeckBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        renderCassetteDeck(blockEntity, poseStack, multiBufferSource, i, j, f, multiBufferSource.getBuffer(class_4722.method_24074()));
    }

    public static void renderCassetteDeck(CassetteDeckBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, class_4588 vertexConsumer) {
        var lidM = IMPModels.CASSETTE_DECK_LID.get();

        float lidOpen = blockEntity.getLidOpenProgress(f) / (float) blockEntity.getLidOpenProgressAll();

        poseStack.method_22903();
        OERenderUtils.poseRotateDirection(poseStack, blockEntity.method_11010().method_11654(CassetteDeckBlock.FACING), 1);

        if (lidOpen != 0) {
            poseStack.method_22903();
            OERenderUtils.poseTrans16(poseStack, 3.7, 2.225, 3f);
            OERenderUtils.poseScaleAll(poseStack, 0.72f);
            mc.method_1480().method_23178(blockEntity.isChangeCassetteTape() ? blockEntity.getOldCassetteTape() : blockEntity.getCassetteTape(), class_809.class_811.field_4319, i, j, poseStack, multiBufferSource, 0);
            poseStack.method_22909();
        }


        poseStack.method_22903();
        poseStack.method_22904(1, 0, 0);
        OERenderUtils.poseRotateY(poseStack, 180);
        OERenderUtils.poseTrans16(poseStack, 0.6f, 2.35f, -1.9f);
        var monitor = getMonitor(blockEntity.getMonitor());
        float px16 = 1f / 16f;
        monitor.renderAppearance(blockEntity, poseStack, multiBufferSource, class_765.field_32767, j, f, px16 * 7.8f, px16 * 2.275f);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 1.5f, 0.5f, 2f);
        OERenderUtils.poseTrans16(poseStack, 0.125, 0.125, 0.125);
        OERenderUtils.poseRotateX(poseStack, lidOpen * -40f);
        OERenderUtils.poseTrans16(poseStack, -0.125, -0.125, -0.125);
        OERenderUtils.renderModel(poseStack, vertexConsumer, lidM, i, j);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static CassetteDeckMonitor getMonitor(CassetteDeckBlockEntity.MonitorType type) {
        if (monitors.containsKey(type))
            return monitors.get(type);

        var monitor = CassetteDeckMonitor.createdCassetteDeckMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}
