package dev.felnull.imp.item;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class BoomboxEntityRinger implements IBoomboxRinger {
    private final class_1297 entity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxEntityRinger(class_1297 entity, UUID uuid) {
        this.entity = entity;
        this.uuid = uuid;
    }

    @Override
    public class_2561 getRingerName() {
        if (entity instanceof class_1542)
            return class_2561.method_43469("imp.ringer.drop", getBoombox().method_7954());

        return class_2561.method_43469("imp.ringer.have", getBoombox().method_7954(), entity.method_5476());
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218) entity.field_6002;
    }

    @Override
    public UUID getRingerUUID() {
        return uuid;
    }

    @Override
    public boolean exists() {
        return canRing(entity) && !getBoombox().method_7960();
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
     /*
     if (entity instanceof Player player)
            return Pair.of(MusicRingManager.PLAYER_TRACKER, MusicRingManager.createPlayerTracker(player));
        return Pair.of(MusicRingManager.ENTITY_TRACKER, MusicRingManager.createEntityTracker(entity));
      */
        return IMPMusicTrackers.createEntityTracker(entity, getRingerVolume(), getRingerRange());
    }

    @Override
    public @NotNull class_243 getRingerSpatialPosition() {
        return entity.method_19538();
    }

    @NotNull
    private class_1799 getBoombox() {
        if (entity instanceof class_1309 livingEntity) {
            for (class_1304 value : class_1304.values()) {
                var item = livingEntity.method_6118(value);
                if (uuid.equals(BoomboxItem.getRingerUUID(item))) return item;
            }
        }
        if (entity instanceof class_1657 player) {
            var li = player.method_31548().method_5438(lastInventory);
            if (uuid.equals(BoomboxItem.getRingerUUID(li))) return li;

            for (int i = 0; i < player.method_31548().method_5439(); i++) {
                var item = player.method_31548().method_5438(i);
                if (uuid.equals(BoomboxItem.getRingerUUID(item))) {
                    lastInventory = i;
                    return item;
                }
            }
        }
        if (IamMusicPlayer.CONFIG.dropItemRing && entity instanceof class_1542 itemEntity) {
            var item = itemEntity.method_6983();
            if (uuid.equals(BoomboxItem.getRingerUUID(item))) return item;
        }
        return class_1799.field_8037;
    }

    @Override
    public @NotNull BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(getBoombox());
    }

    public static boolean canRing(class_1297 entity) {
        if (!entity.method_5805()) return false;
        if (entity instanceof class_1657 player) return !player.method_7325();
        return true;
    }
}
