package dev.felnull.imp.music.tracker;

import dev.architectury.utils.value.FloatSupplier;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.SpatialType;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_2487;

public class PlayerMusicTracker extends FixedMusicTracker {
    private final class_1657 myPlayer;
    private final class_1924 entityGetter;
    private final FloatSupplier deltaSupplier;
    private UUID playerId;

    public PlayerMusicTracker(class_1657 myPlayer, class_1924 entityGetter, FloatSupplier deltaSupplier) {
        this.myPlayer = myPlayer;
        this.entityGetter = entityGetter;
        this.deltaSupplier = deltaSupplier;
    }

    public PlayerMusicTracker(class_1657 player, float volume, float range) {
        super(new MusicSpeakerInfo(player.method_19538(), volume, range, new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST)));
        this.playerId = player.method_7334().getId();
        this.myPlayer = null;
        this.entityGetter = null;
        this.deltaSupplier = null;
    }

    @Override
    public MusicSpeakerInfo getSpeakerInfo() {
        var sp = super.getSpeakerInfo();
        if (myPlayer != null && entityGetter != null && playerId != null && deltaSupplier != null) {
            var pl = entityGetter.method_18470(playerId);
            if (pl != null) {
                SpatialType spt = myPlayer.method_7334().getId().equals(playerId) ? SpatialType.DISABLE : sp.fixedInfo().spatialType();
                return new MusicSpeakerInfo(EntityMusicTracker.getEntityPosition(pl, deltaSupplier.getAsFloat()), sp.volume(), sp.range(), new MusicSpeakerFixedInfo(-1, spt));
            }
        }
        return sp;
    }

    @Override
    public void save(class_2487 tag) {
        super.save(tag);
        tag.method_25927("PlayerId", playerId);
    }

    @Override
    public void load(class_2487 tag) {
        super.load(tag);
        this.playerId = tag.method_25926("PlayerId");
    }
}
