/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.IMPMusicTrackerFactory;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class MusicManagerScreen
extends IMPBaseContainerScreen<MusicManagerMenu> {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/music_manager_base.png");
    private final Map<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor> monitors = new HashMap<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor>();
    private final UUID musicPlayerId = UUID.randomUUID();
    public boolean lastSearch;
    protected MusicManagerMonitor monitor;
    public byte[] musicFileImage;

    public MusicManagerScreen(MusicManagerMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 386;
        this.field_2779 = 227;
        this.bgTextureWidth = 512;
        this.bgTextureHeight = 512;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new PowerButton(this, this.field_2776 + 368, this.field_2800 + 4, 12, 12, 386, 0, BG_TEXTURE, this.bgTextureWidth, this.bgTextureHeight));
        this.changeScreenMonitor(this.getBEMonitorType());
        this.insMonitor(this.getBEMonitorType());
    }

    public void insMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (this.monitor != null && this.monitor.getType() != type) {
            this.stopMusic();
        }
        class_2487 tag = new class_2487();
        tag.method_10582("type", type.getName());
        this.instruction("set_monitor", tag);
    }

    public void insAddPlayList(UUID playListId) {
        class_2487 tag = new class_2487();
        tag.method_25927("playlist", playListId);
        this.instruction("add_playlist", tag);
    }

    private void changeScreenMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (this.monitor != null) {
            if (this.monitor.getType() != MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC || type != MusicManagerBlockEntity.MonitorType.ADD_MUSIC) {
                this.musicFileImage = null;
            }
            this.monitor.renderables.forEach(n -> {
                if (n instanceof class_364) {
                    class_364 guiEventListener = (class_364)n;
                    this.method_37066(guiEventListener);
                }
            });
            this.monitor.depose();
        }
        if (!this.monitors.containsKey((Object)type)) {
            this.monitors.put(type, MusicManagerMonitor.createdMusicMonitor(type, this));
        }
        this.monitor = this.monitors.get((Object)type);
        this.monitor.init(this.field_2776, this.field_2800);
        this.monitor.renderables.forEach(n -> {
            if (n instanceof class_339) {
                class_339 widget = (class_339)n;
                this.method_37063((class_364)widget);
            }
        });
    }

    private MusicManagerBlockEntity.MonitorType getBEMonitorType() {
        class_2586 class_25862 = this.getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return musicManagerBlockEntity.getMonitor((class_1657)MusicManagerScreen.mc.field_1724);
        }
        return MusicManagerBlockEntity.MonitorType.OFF;
    }

    public void insImportPlayListMusicCount(int count) {
        class_2487 tag = new class_2487();
        tag.method_10569("count", count);
        this.instruction("set_import_playlist_music_count", tag);
    }

    public void insImportPlayListAuthor(String author) {
        class_2487 tag = new class_2487();
        tag.method_10582("author", author);
        this.instruction("set_import_playlist_author", tag);
    }

    public void insImportPlayListName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_import_playlist_name", tag);
    }

    public void insImportIdentifier(String identifier) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", identifier);
        this.instruction("set_import_identifier", tag);
    }

    public void insImageURL(String url) {
        class_2487 tag = new class_2487();
        tag.method_10582("url", url);
        this.instruction("set_image_url", tag);
    }

    public void insImage(ImageInfo image) {
        class_2487 tag = new class_2487();
        tag.method_10566("image", (class_2520)image.createSavedTag());
        this.instruction("set_image", tag);
    }

    public void insCreateName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_create_name", tag);
    }

    public void insPublishing(String publishing) {
        class_2487 tag = new class_2487();
        tag.method_10582("publishing", publishing);
        this.instruction("set_publishing", tag);
    }

    public void insInitialAuthority(String initialAuthority) {
        class_2487 tag = new class_2487();
        tag.method_10582("initial_authority", initialAuthority);
        this.instruction("set_initial_authority", tag);
    }

    public void insInvitePlayerName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_invite_player_name", tag);
    }

    public void insInvitePlayers(List<UUID> players) {
        class_2487 tag = new class_2487();
        OENbtUtils.writeUUIDList((class_2487)tag, (String)"players", players);
        this.instruction("set_invite_players", tag);
    }

    public void insSelectedPlayList(UUID selectedPlayList) {
        class_2487 tag = new class_2487();
        if (selectedPlayList != null) {
            tag.method_25927("playlist", selectedPlayList);
        }
        this.instruction("set_selected_playlist", tag);
    }

    public void insSelectedMusic(@Nullable UUID selectedMusic) {
        class_2487 tag = new class_2487();
        if (selectedMusic != null) {
            tag.method_25927("music", selectedMusic);
        }
        this.instruction("set_selected_music", tag);
    }

    public void insSelectedPlayer(@Nullable UUID selectedPlayer) {
        class_2487 tag = new class_2487();
        if (selectedPlayer != null) {
            tag.method_25927("player", selectedPlayer);
        }
        this.instruction("set_selected_player", tag);
    }

    public void insMusicLoaderType(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_music_loader_type", tag);
    }

    public void insMusicSourceName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_music_source_name", tag);
    }

    public void insMusicSource(MusicSource source) {
        if (source == null) {
            source = MusicSource.EMPTY;
        }
        class_2487 tag = new class_2487();
        tag.method_10566("MusicSource", (class_2520)source.createSavedTag());
        this.instruction("set_music_source", tag);
    }

    public void insMusicSearchName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_music_search_name", tag);
    }

    public void insMusicAuthor(String author) {
        class_2487 tag = new class_2487();
        tag.method_10582("author", author);
        this.instruction("set_music_author", tag);
    }

    public void onInstructionReturn(String name, class_2487 data) {
        super.onInstructionReturn(name, data);
        if ("add_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                this.insSelectedPlayList(data.method_25926("playlist"));
            }
        } else if ("set_selected_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                this.monitor.onUpdateSelectedPlayList(data.method_25926("playlist"));
            } else {
                this.monitor.onUpdateSelectedPlayList(null);
            }
        }
    }

    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    protected void method_2388(class_4587 poseStack, int i, int j) {
        this.field_22793.method_30883(poseStack, this.field_22785, (float)this.field_25267, (float)this.field_25268, 0x404040);
    }

    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
        super.method_2389(poseStack, f, i, j);
        if (this.monitor != null) {
            this.monitor.render(poseStack, f, i, j);
        }
    }

    protected void method_37432() {
        super.method_37432();
        if (this.monitor != null) {
            if (this.getBEMonitorType() != this.monitor.getType()) {
                this.changeScreenMonitor(this.getBEMonitorType());
            }
            this.monitor.tick();
        }
    }

    public void method_25419() {
        super.method_25419();
        if (this.monitor != null) {
            this.monitor.depose();
        }
        this.stopMusic();
    }

    public void method_29638(List<Path> list) {
        if (this.monitor != null) {
            this.monitor.onFilesDrop(list);
        }
    }

    public void playMusic(MusicSource source, long postion) {
        this.stopMusic();
        this.getMusicEngine().loadAndPlay(this.musicPlayerId, source, postion, false);
        this.getMusicEngine().addSpeaker(this.musicPlayerId, this.musicPlayerId, IMPMusicTrackerFactory.linked(IMPMusicTrackers.createPlayerTracker((class_1657)MusicManagerScreen.mc.field_1724, 1.0f, 10.0f)));
    }

    public void stopMusic() {
        this.getMusicEngine().stop(this.musicPlayerId);
    }

    public boolean isMusicPlaying() {
        return this.getMusicEngine().isPlaying(this.musicPlayerId);
    }

    public boolean isMusicLoading() {
        return this.getMusicEngine().isLoading(this.musicPlayerId);
    }

    private MusicEngine getMusicEngine() {
        return MusicEngine.getInstance();
    }

    public MusicEntry getMusicPlayer() {
        return this.getMusicEngine().getMusicEntry(this.musicPlayerId);
    }
}

