/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.architectury.utils.value.Value;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.components.ContinuousWidget;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlayBackFiniteBaseBMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class RemotePlayBackBMonitor
extends PlayBackFiniteBaseBMMonitor {
    private static final class_2960 BACK_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/playback_back.png");
    private SmartButton backButton;
    private ContinuousWidget continuousWidget;

    public RemotePlayBackBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.backButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 15, this.getStartY() + this.height - 12, 14, 11, (class_2561)class_2561.method_43471((String)"gui.back"), n -> this.setMonitor(BoomboxData.MonitorType.REMOTE_PLAYBACK_SELECT)));
        this.backButton.setHideText(true);
        this.backButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8);
        this.continuousWidget = this.addRenderWidget(new ContinuousWidget(this.getStartX() + 112, this.getStartY() + 13, new Value<BoomboxData.ContinuousType>(){

            public void accept(BoomboxData.ContinuousType continuousType) {
                RemotePlayBackBMonitor.this.getScreen().insContinuousType(continuousType);
            }

            public BoomboxData.ContinuousType get() {
                return RemotePlayBackBMonitor.this.getScreen().getBoomBoxData().getContinuousType();
            }
        }));
        this.continuousWidget.field_22764 = this.canPlay();
    }

    @Override
    public void tick() {
        super.tick();
        this.continuousWidget.field_22763 = this.canPlay();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((class_2960)BACK_BG_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtils.renderTextureSprite((class_2960)BACK_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 15, this.height - 12, 0.002f, 14.0f, 11.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8, 256, 256);
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, data.getContinuousType().getComponent(), 132.0f, 16.0f, 0.002f, onPxW, onPxH, monitorHeight, i, -15639282);
    }

    @Override
    @NotNull
    protected ImageInfo getPlayBackImage(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected String getPlayBackName(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getName();
        }
        return "";
    }

    @Override
    @NotNull
    protected String getPlayBackAuthor(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getAuthor();
        }
        return "";
    }

    @Override
    @NotNull
    protected MusicSource getPlayBackSource(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getSource();
        }
        return MusicSource.EMPTY;
    }

    private Music getMusic() {
        return this.getScreen().getBoomBoxData().getSelectedMusic();
    }

    private Music getMusic(BoomboxData data) {
        return data.getSelectedMusic();
    }

    @Override
    protected boolean isShortTipProgressBar() {
        return true;
    }
}

