/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class MusicSyncManager {
    private static final class_310 mc = class_310.method_1551();
    private static final MusicSyncManager INSTANCE = new MusicSyncManager();
    public List<MusicPlayList> myPlayList;
    private long myPlayListLastUpdateTime;
    public PlayListInfo myPlayListInfo;
    public List<MusicPlayList> canJoinPlayList;
    private long canJoinPlayListLastUpdateTime;
    public PlayListInfo canJoinPlayListInfo;
    public final Map<UUID, List<Music>> musics = new HashMap<UUID, List<Music>>();
    private final Map<UUID, Long> musicUpdateTimes = new HashMap<UUID, Long>();

    public static MusicSyncManager getInstance() {
        return INSTANCE;
    }

    @Nullable
    public List<Music> getMusics(@Nullable UUID playList) {
        if (playList == null) {
            return null;
        }
        long time = 0L;
        if (this.musicUpdateTimes.containsKey(playList)) {
            time = this.musicUpdateTimes.get(playList);
        } else {
            this.musicUpdateTimes.put(playList, 0L);
        }
        if (System.currentTimeMillis() - time >= 60000L) {
            this.sendRequest(IMPPackets.MusicSyncType.MUSIC_BY_PLAYLIST, playList);
            this.musicUpdateTimes.put(playList, System.currentTimeMillis());
        }
        return this.musics.get(playList);
    }

    public List<MusicPlayList> getMyPlayList() {
        if (System.currentTimeMillis() - this.myPlayListLastUpdateTime >= 60000L) {
            this.sendRequest(IMPPackets.MusicSyncType.PLAYLIST_MY_LIST, MusicSyncManager.mc.field_1724.method_7334().getId());
            this.myPlayListLastUpdateTime = System.currentTimeMillis();
        }
        return this.myPlayList;
    }

    public PlayListInfo getMyPlayListInfo() {
        return this.myPlayListInfo;
    }

    public List<MusicPlayList> getCanJoinPlayList() {
        if (System.currentTimeMillis() - this.canJoinPlayListLastUpdateTime >= 60000L) {
            this.sendRequest(IMPPackets.MusicSyncType.PLAYLIST_CAN_JOIN, MusicSyncManager.mc.field_1724.method_7334().getId());
            this.canJoinPlayListLastUpdateTime = System.currentTimeMillis();
        }
        return this.canJoinPlayList;
    }

    public PlayListInfo getCanJoinPlayListInfo() {
        return this.canJoinPlayListInfo;
    }

    public void reset() {
        this.myPlayListLastUpdateTime = 0L;
        this.canJoinPlayListLastUpdateTime = 0L;
        this.musicUpdateTimes.clear();
        this.myPlayList = null;
        this.canJoinPlayList = null;
        this.musics.clear();
    }

    private void sendRequest(IMPPackets.MusicSyncType type, UUID uuid) {
        if (uuid == null) {
            return;
        }
        NetworkManager.sendToServer((class_2960)IMPPackets.MUSIC_SYNC, (class_2540)new IMPPackets.MusicSyncRequestMessage(type, uuid).toFBB());
    }

    public record PlayListInfo(int playerCount, int playListCount, int musicCount) {
    }
}

