/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.speaker;

import dev.felnull.imp.api.MusicSpeakerInfoAccess;
import dev.felnull.imp.api.client.MusicSpeakerAccess;
import dev.felnull.imp.client.integration.SoundPhysicsRemasteredIntegration;
import dev.felnull.imp.client.music.speaker.MusicBuffer;
import dev.felnull.imp.client.util.MusicMath;
import dev.felnull.imp.client.util.MusicUtils;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.tracker.MusicTracker;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.openal.AL11;

public class MusicSpeaker
implements MusicSpeakerAccess {
    private final Queue<MusicBuffer> buffers = new ArrayDeque<MusicBuffer>();
    private final int source;
    private final MusicSpeakerFixedInfo fixedInfo;
    private final UUID musicPlayerId;
    private final UUID speakerId;
    private MusicTracker tracker;
    private long startTime = -1L;
    private long pauseTime = -1L;
    private long stopTime = -1L;
    private long totalPauseTime;
    private long scheduledStartTime;
    private long liveTime = System.currentTimeMillis();
    private boolean playStarted;
    private boolean broken;
    private boolean pause;

    public MusicSpeaker(UUID musicPlayerId, UUID speakerId, MusicTracker tracker) {
        this.musicPlayerId = musicPlayerId;
        this.speakerId = speakerId;
        this.tracker = tracker;
        this.fixedInfo = tracker.getSpeakerInfo().fixedInfo();
        MusicUtils.assertOnMusicTick();
        this.source = AL11.alGenSources();
        this.alSourceInit();
        this.alSourceUpdate();
        MusicUtils.checkALError();
    }

    public boolean canPlay() {
        return !this.isDead() && !this.buffers.isEmpty() && this.getLiveTime() >= this.scheduledStartTime;
    }

    public boolean isPlaying() {
        return this.getPlayState() == 4114 || this.getPlayState() == 4115;
    }

    public void setScheduledStartTime(long scheduledStartTime) {
        this.scheduledStartTime = this.getLiveTime() + scheduledStartTime;
    }

    public void tick() {
        if (this.broken) {
            return;
        }
        MusicUtils.assertOnMusicTick();
        this.alSourceUpdate();
        if (this.isPlaying() && SoundPhysicsRemasteredIntegration.INSTANCE.isEnable()) {
            SoundPhysicsRemasteredIntegration.INSTANCE.onSound(this.musicPlayerId, this.speakerId, this.source, MusicUtils.isSpatial(this.fixedInfo.spatialType()) ? this.tracker.getSpeakerInfo().getPosition() : null);
        }
        MusicUtils.checkALError();
    }

    public MusicTracker getTracker() {
        return this.tracker;
    }

    public void insertBuffer(MusicBuffer buffer) {
        buffer.addSpeaker(this);
        this.buffers.add(buffer);
        MusicUtils.assertOnMusicTick();
        AL11.alSourceQueueBuffers((int)this.source, (int)buffer.getBufferId());
        MusicUtils.checkALError();
    }

    public void play(long delay) {
        if (this.broken) {
            return;
        }
        if (this.pause) {
            this.pauseTime = System.currentTimeMillis();
        }
        this.playStarted = true;
        this.startTime = System.currentTimeMillis();
        this.pause = true;
        MusicUtils.assertOnMusicTick();
        float secdelay = (float)delay / 1000.0f;
        AL11.alSourcef((int)this.source, (int)4132, (float)secdelay);
        AL11.alSourcePlay((int)this.source);
        MusicUtils.checkALError();
    }

    public void pause() {
        this.pauseTime = System.currentTimeMillis();
        if (this.getPlayState() == 4114) {
            AL11.alSourcePause((int)this.source);
        }
    }

    public void resume() {
        if (this.pauseTime >= 0L) {
            this.totalPauseTime += System.currentTimeMillis() - this.pauseTime;
        }
        this.pauseTime = -1L;
        this.pause = false;
        if (this.getPlayState() == 4115) {
            AL11.alSourcePlay((int)this.source);
        }
    }

    private int getPlayState() {
        return AL11.alGetSourcei((int)this.source, (int)4112);
    }

    public void destroy() throws Exception {
        if (this.broken) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        MusicUtils.assertOnMusicTick();
        AL11.alDeleteSources((int)this.source);
        MusicUtils.checkALError();
        for (MusicBuffer musicBuffer : this.buffers) {
            musicBuffer.removeSpeaker(this);
        }
        if (SoundPhysicsRemasteredIntegration.INSTANCE.isEnable()) {
            SoundPhysicsRemasteredIntegration.INSTANCE.onDestroy(this.musicPlayerId, this.speakerId);
        }
        this.broken = true;
    }

    public void stop() {
        if (this.broken) {
            return;
        }
        MusicUtils.assertOnMusicTick();
        if (this.getPlayState() != 4116) {
            this.stopTime = System.currentTimeMillis();
        }
        AL11.alSourceStop((int)this.source);
        MusicUtils.checkALError();
    }

    public void setTracker(MusicTracker tracker) {
        this.tracker = tracker;
        if (!this.fixedInfo.equals(this.tracker.getSpeakerInfo().fixedInfo())) {
            this.stop();
            return;
        }
        this.alSourceUpdate();
    }

    private void alSourceInit() {
        MusicUtils.assertOnMusicTick();
        AL11.alSourcei((int)this.source, (int)4103, (int)0);
        MusicUtils.checkALError();
    }

    private void alSourceUpdate() {
        MusicUtils.assertOnMusicTick();
        MusicSpeakerInfo spi = this.tracker.getSpeakerInfo();
        boolean sp = MusicUtils.isSpatial(this.fixedInfo.spatialType());
        AL11.alSourcei((int)this.source, (int)514, (int)(sp ? 0 : 1));
        if (sp) {
            AL11.alSource3f((int)this.source, (int)4100, (float)((float)spi.position().method_10216()), (float)((float)spi.position().method_10214()), (float)((float)spi.position().method_10215()));
            AL11.alSourcef((int)this.source, (int)4106, (float)((float)MusicMath.calculateVolume(spi.volume())));
            this.linearAttenuation(spi.range());
        } else {
            AL11.alSourcef((int)this.source, (int)4106, (float)((float)MusicMath.calculateVolume(MusicMath.calculatePseudoAttenuation(spi.position(), spi.range(), (double)spi.volume()))));
        }
        MusicUtils.checkALError();
    }

    private void linearAttenuation(float r) {
        AL11.alSourcei((int)this.source, (int)53248, (int)53251);
        AL11.alSourcef((int)this.source, (int)4131, (float)r);
        AL11.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL11.alSourcef((int)this.source, (int)4128, (float)0.0f);
    }

    public void releaseBuffers() {
        MusicBuffer buf;
        MusicUtils.assertOnMusicTick();
        int proBuffs = AL11.alGetSourcei((int)this.source, (int)4118);
        int[] bufIds = null;
        for (int i = 0; i < proBuffs && (buf = this.buffers.poll()) != null; ++i) {
            buf.removeSpeaker(this);
            bufIds = ArrayUtils.add(bufIds, (int)buf.getBufferId());
        }
        if (bufIds != null) {
            AL11.alSourceUnqueueBuffers((int)this.source, bufIds);
        }
        MusicUtils.checkALError();
    }

    public long getPlayTime() {
        if (this.startTime < 0L) {
            return 0L;
        }
        long pt = this.totalPauseTime;
        if (this.pauseTime >= 0L) {
            pt += System.currentTimeMillis() - this.pauseTime;
        }
        long ct = System.currentTimeMillis();
        if (this.stopTime >= 0L) {
            ct = this.stopTime;
        }
        return ct - this.startTime - pt;
    }

    private long getLiveTime() {
        long pt = this.totalPauseTime;
        if (this.pauseTime >= 0L) {
            pt += System.currentTimeMillis() - this.pauseTime;
        }
        return System.currentTimeMillis() - this.liveTime - pt;
    }

    public boolean isDead() {
        return this.playStarted && this.getPlayState() == 4116;
    }

    public MusicSpeakerFixedInfo getFixedInfo() {
        return this.fixedInfo;
    }

    @Override
    public MusicSpeakerInfoAccess getInfo() {
        return this.tracker.getSpeakerInfo();
    }
}

