/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.wav;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class WavTrackProvider {
    private static final int BLOCKS_IN_BUFFER = 4096;
    private final SeekableInputStream inputStream;
    private final DataInput dataInput;
    private final WavFileInfo info;
    private final AudioPipeline downstream;
    private final short[] buffer;
    private final ShortBuffer nioBuffer;
    private final byte[] rawBuffer;

    public WavTrackProvider(AudioProcessingContext context, SeekableInputStream inputStream, WavFileInfo info) {
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.info = info;
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(info.channelCount, info.sampleRate));
        this.buffer = info.getPadding() > 0 ? new short[info.channelCount * 4096] : null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(info.blockAlign * 4096).order(ByteOrder.LITTLE_ENDIAN);
        this.rawBuffer = byteBuffer.array();
        this.nioBuffer = byteBuffer.asShortBuffer();
    }

    public void seekToTimecode(long timecode) {
        try {
            long fileOffset = timecode * (long)this.info.sampleRate / 1000L * (long)this.info.blockAlign + this.info.startOffset;
            this.inputStream.seek(fileOffset);
            this.downstream.seekPerformed(timecode, timecode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void provideFrames() throws InterruptedException {
        try {
            int blockCount;
            while ((blockCount = this.getNextChunkBlocks()) > 0) {
                if (this.buffer != null) {
                    this.processChunkWithPadding(blockCount);
                    continue;
                }
                this.processChunk(blockCount);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.downstream.close();
    }

    private void processChunkWithPadding(int blockCount) throws IOException, InterruptedException {
        this.readChunkToBuffer(blockCount);
        int padding = this.info.getPadding() / 2;
        int sampleCount = blockCount * this.info.channelCount;
        int indexInBlock = 0;
        for (int i = 0; i < sampleCount; ++i) {
            this.buffer[i] = this.nioBuffer.get();
            if (++indexInBlock != this.info.channelCount) continue;
            this.nioBuffer.position(this.nioBuffer.position() + padding);
            indexInBlock = 0;
        }
        this.downstream.process(this.buffer, 0, blockCount * this.info.channelCount);
    }

    private void processChunk(int blockCount) throws IOException, InterruptedException {
        this.readChunkToBuffer(blockCount);
        this.downstream.process(this.nioBuffer);
    }

    private void readChunkToBuffer(int blockCount) throws IOException {
        int bytesToRead = blockCount * this.info.blockAlign;
        this.dataInput.readFully(this.rawBuffer, 0, bytesToRead);
        this.nioBuffer.position(0);
        this.nioBuffer.limit(bytesToRead / 2);
    }

    private int getNextChunkBlocks() {
        long endOffset = this.info.startOffset + (long)this.info.blockAlign * this.info.blockCount;
        return (int)Math.min((endOffset - this.inputStream.getPosition()) / (long)this.info.blockAlign, 4096L);
    }
}

