/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip;

import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Ipv4Block
extends IpBlock<Inet4Address> {
    private static final Pattern CIDR_REGEX = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})");
    private static final int NBITS = 32;
    private static final Logger log = LoggerFactory.getLogger(Ipv4Block.class);
    private static final Random random = new Random();
    private final int maskBits;
    private final int address;

    public static boolean isIpv4CidrBlock(String cidr) {
        if (!cidr.contains("/")) {
            cidr = cidr + "/32";
        }
        return CIDR_REGEX.matcher(cidr).matches();
    }

    private static int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = Ipv4Block.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    private static int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    public Ipv4Block(String cidr) {
        Matcher matcher;
        if (!cidr.contains("/")) {
            cidr = cidr + "/32";
        }
        if (!(matcher = CIDR_REGEX.matcher(cidr)).matches()) {
            throw new IllegalArgumentException("Could not parse [" + cidr + "]");
        }
        this.address = Ipv4Block.matchAddress(matcher);
        this.maskBits = Integer.parseInt(matcher.group(5));
        log.info("Using Ipv4Block with {} addresses", (Object)this.getSize());
    }

    @Override
    public Inet4Address getRandomAddress() {
        if (this.maskBits == 32) {
            return this.intToAddress(this.address);
        }
        int randMask = Integer.MAX_VALUE >> this.maskBits - 1;
        int maskedRandom = random.nextInt() & randMask;
        Inet4Address inetAddress = this.intToAddress(this.address + maskedRandom);
        log.info(inetAddress.toString());
        return inetAddress;
    }

    @Override
    public Inet4Address getAddressAtIndex(long index) {
        if ((double)index > Math.pow(2.0, 32 - this.maskBits)) {
            throw new IllegalArgumentException("Index out of bounds for provided CIDR Block");
        }
        return this.intToAddress(this.address + (int)index);
    }

    @Override
    public Class<Inet4Address> getType() {
        return Inet4Address.class;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(2L).pow(32 - this.maskBits);
    }

    @Override
    public int getMaskBits() {
        return this.maskBits;
    }

    private Inet4Address intToAddress(int val) {
        byte[] octets = new byte[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            octets[n] = (byte)(octets[n] | val >>> 8 * (3 - j) & 0xFF);
        }
        try {
            return (Inet4Address)Inet4Address.getByAddress(octets);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

