/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    private final Map<class_3218, MusicRing> MUSIC_RINGS = new HashMap<class_3218, MusicRing>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(class_3218 level) {
        MusicRing ring = this.MUSIC_RINGS.get(level);
        if (ring == null) {
            ring = new MusicRing(level);
            this.MUSIC_RINGS.put(level, ring);
        }
        ring.tick();
    }

    public Map<class_3218, MusicRing> getMusicRingers() {
        return this.MUSIC_RINGS;
    }

    public void restartRinger(class_3218 level, UUID uuid) {
        MusicRing ring = this.MUSIC_RINGS.get(level);
        if (ring != null) {
            ring.restart(uuid);
        }
    }

    public void addRinger(class_3218 level, IMusicRinger ringer) {
        MusicRing ring = this.MUSIC_RINGS.get(level);
        if (ring != null) {
            ring.addRinger(ringer);
        }
    }

    public boolean isWaitRinger(UUID uuid, class_3218 level) {
        MusicRing ring = this.MUSIC_RINGS.get(level);
        if (ring != null) {
            return ring.isWaitRinger(uuid);
        }
        return false;
    }

    public void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, IMPPackets.MusicRingResponseStateType state) {
        MusicRing ring = this.MUSIC_RINGS.get(player.method_14220());
        if (ring != null) {
            ring.onUpdate(player, uuid, waitUUID, state);
        }
    }

    public void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        MusicRing ring = this.MUSIC_RINGS.get(player.method_14220());
        if (ring != null) {
            ring.addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
        }
    }

    public MusicRing getMusicRing(class_3218 level) {
        return this.getMusicRingers().get(level);
    }

    public boolean hasRinger(UUID uuid) {
        for (class_3218 serverLevel : this.MUSIC_RINGS.keySet()) {
            if (!this.hasRinger(serverLevel, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRinger(class_3218 level, UUID uuid) {
        MusicRing ring = this.MUSIC_RINGS.get(level);
        return ring != null && ring.hasRinger(uuid);
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (class_3218 serverLevel : this.MUSIC_RINGS.keySet()) {
            IMusicRinger r;
            MusicRing mr = this.MUSIC_RINGS.get(serverLevel);
            if (mr == null || (r = mr.getRingers().get(uuid)) == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public class_3218 getLevel(MusicRing ring) {
        for (Map.Entry<class_3218, MusicRing> entry : this.MUSIC_RINGS.entrySet()) {
            if (entry.getValue() != ring) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pause() {
        this.MUSIC_RINGS.forEach((n, m) -> m.pause());
    }

    public void resume() {
        this.MUSIC_RINGS.forEach((n, m) -> m.resume());
    }

    public void clear() {
        this.MUSIC_RINGS.forEach((n, m) -> m.depose());
        this.MUSIC_RINGS.clear();
    }
}

