/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntities;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassetteDeckBlockEntity
extends IMPBaseEntityBlockEntity
implements IMusicRinger {
    private class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<UUID, UUID>();
    private Music music = null;
    private MonitorType monitor = MonitorType.OFF;
    private class_1799 oldCassetteTape = class_1799.field_8037;
    private final UUID ringerUUID = UUID.randomUUID();
    private boolean changeCassetteTape;
    private boolean lidOpen;
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int cassetteWriteProgress;
    private int volume = 150;
    private boolean mute;
    private boolean playing;
    private long position;
    private boolean loop;
    private boolean loadingMusic;

    public CassetteDeckBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)IMPBlockEntities.CASSETTE_DECK.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, CassetteDeckBlockEntity blockEntity) {
        blockEntity.lidOpenProgressOld = blockEntity.lidOpenProgress;
        if (blockEntity.lidOpen) {
            if (blockEntity.lidOpenProgress < blockEntity.getLidOpenProgressAll()) {
                ++blockEntity.lidOpenProgress;
            }
        } else if (blockEntity.lidOpenProgress > 0) {
            --blockEntity.lidOpenProgress;
        }
        if (!level.method_8608()) {
            if (blockEntity.isPowered()) {
                if (blockEntity.monitor == MonitorType.OFF) {
                    blockEntity.setMonitor(MonitorType.MENU);
                }
            } else if (blockEntity.monitor != MonitorType.OFF) {
                blockEntity.setMonitor(MonitorType.OFF);
            }
            if ((blockEntity.getMusic() == null || blockEntity.getCassetteTape().method_7960() || IMPItemUtil.isAntenna(blockEntity.getCassetteTape())) && blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                blockEntity.setMonitor(MonitorType.WRITE);
            }
            if (blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                if (blockEntity.getCassetteWriteProgress() >= blockEntity.getCassetteWriteProgressAll()) {
                    blockEntity.writeCassetteTape();
                    blockEntity.setMonitor(MonitorType.WRITE);
                    blockEntity.setCassetteWriteProgress(0);
                } else {
                    blockEntity.setCassetteWriteProgress(blockEntity.getCassetteWriteProgress() + 1);
                }
            } else if (blockEntity.getCassetteWriteProgress() != 0) {
                blockEntity.setCassetteWriteProgress(0);
            }
            if (blockEntity.monitor != MonitorType.PLAYBACK || !blockEntity.hasMusicCassetteTape()) {
                blockEntity.setRingerPosition(0L);
                if (blockEntity.isPlaying()) {
                    blockEntity.setPlaying(false);
                }
            }
            if (blockEntity.changeCassetteTape) {
                if (!blockEntity.isLidOpen()) {
                    blockEntity.startLidOpen(true);
                }
                if (blockEntity.lidOpenProgress >= blockEntity.getLidOpenProgressAll()) {
                    blockEntity.changeCassetteTape = false;
                    blockEntity.startLidOpen(false);
                }
            }
            blockEntity.loadingMusic = blockEntity.isRingerWait();
            blockEntity.ringerTick();
        }
        blockEntity.baseAfterTick();
    }

    private boolean canWriteCassetteTape() {
        return this.getMusic() != null && !this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    private void writeCassetteTape() {
        if (this.canWriteCassetteTape()) {
            CassetteTapeItem.setMusic(this.getCassetteTape(), this.getMusic());
            this.method_5431();
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.lidOpen = tag.method_10577("LidOpen");
        if (this.lidOpen) {
            this.lidOpenProgress = this.getLidOpenProgressAll();
        }
        this.monitor = MonitorType.getByName(tag.method_10558("Monitor"));
        OENbtUtils.readUUIDMap((class_2487)tag, (String)"PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (tag.method_10545("Music")) {
            this.music = (Music)TagSerializable.loadSavedTag((class_2487)tag.method_10562("Music"), (TagSerializable)new Music());
        }
        this.cassetteWriteProgress = tag.method_10550("CassetteWriteProgress");
        this.volume = tag.method_10550("Volume");
        this.mute = tag.method_10577("Mute");
        this.playing = tag.method_10577("Playing");
        this.position = tag.method_10537("Position");
        this.loop = tag.method_10577("Loop");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10582("Monitor", this.monitor.getName());
        OENbtUtils.readUUIDMap((class_2487)tag, (String)"PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (this.music != null) {
            tag.method_10566("Music", (class_2520)this.music.createSavedTag());
        }
        tag.method_10569("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Mute", this.mute);
        tag.method_10556("Playing", this.playing);
        tag.method_10544("Position", this.position);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("LoadingMusic", this.loadingMusic);
    }

    public void saveToUpdateTag(class_2487 tag) {
        super.saveToUpdateTag(tag);
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10566("OldCassetteTape", (class_2520)this.oldCassetteTape.method_7953(new class_2487()));
        tag.method_10556("ChangeCassetteTape", this.changeCassetteTape);
        tag.method_10582("Monitor", this.monitor.getName());
        OENbtUtils.writeUUIDMap((class_2487)tag, (String)"PlayerSelectPlaylist", this.playerSelectPlaylists);
        if (this.music != null) {
            tag.method_10566("Music", (class_2520)this.music.createSavedTag());
        }
        tag.method_10569("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Mute", this.mute);
        tag.method_10556("Playing", this.playing);
        tag.method_10544("Position", this.position);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("LoadingMusic", this.loadingMusic);
    }

    public void loadToUpdateTag(class_2487 tag) {
        super.loadToUpdateTag(tag);
        this.lidOpen = tag.method_10577("LidOpen");
        this.oldCassetteTape = class_1799.method_7915((class_2487)tag.method_10562("OldCassetteTape"));
        this.changeCassetteTape = tag.method_10577("ChangeCassetteTape");
        this.monitor = MonitorType.getByName(tag.method_10558("Monitor"));
        OENbtUtils.readUUIDMap((class_2487)tag, (String)"PlayerSelectPlaylist", this.playerSelectPlaylists);
        this.music = tag.method_10545("Music") ? (Music)TagSerializable.loadSavedTag((class_2487)tag.method_10562("Music"), (TagSerializable)new Music()) : null;
        this.cassetteWriteProgress = tag.method_10550("CassetteWriteProgress");
        this.volume = tag.method_10550("Volume");
        this.mute = tag.method_10577("Mute");
        this.playing = tag.method_10577("Playing");
        this.position = tag.method_10537("Position");
        this.loop = tag.method_10577("Loop");
        this.loadingMusic = tag.method_10577("LoadingMusic");
    }

    public void method_5447(int i, class_1799 stack) {
        if (i == 0) {
            this.onCassetteTapeChange(stack, this.getCassetteTape());
        }
        this.setItemNoChange(i, stack);
    }

    public void setItemNoChange(int i, class_1799 stack) {
        super.method_5447(i, stack);
    }

    public boolean isLoadingMusic() {
        return this.loadingMusic;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.method_5431();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
        this.method_5431();
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
        this.method_5431();
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.method_5431();
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (this.volume != volume) {
            this.setMute(false);
        }
        this.volume = class_3532.method_15340((int)volume, (int)0, (int)300);
        this.method_5431();
    }

    public void setPlayerSelectPlayList(class_3222 player, UUID uuid) {
        if (uuid != null) {
            this.playerSelectPlaylists.put(player.method_7334().getId(), uuid);
        } else {
            this.playerSelectPlaylists.remove(player.method_7334().getId());
        }
        this.method_5431();
    }

    public UUID getPlayerSelectPlayList(class_1657 player) {
        return this.playerSelectPlaylists.get(player.method_7334().getId());
    }

    public int getCassetteWriteProgress() {
        return this.cassetteWriteProgress;
    }

    public void setCassetteWriteProgress(int cassetteWriteProgress) {
        this.cassetteWriteProgress = cassetteWriteProgress;
        if (!this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            CassetteTapeItem.setTapePercentage(this.getCassetteTape(), (float)cassetteWriteProgress / (float)this.getCassetteWriteProgressAll());
        }
        this.method_5431();
    }

    public int getLidOpenProgressAll() {
        return 10;
    }

    public MonitorType getMonitor() {
        return this.monitor;
    }

    public float getLidOpenProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.lidOpenProgressOld, (float)this.lidOpenProgress);
    }

    public void startLidOpen(boolean open) {
        this.setLidOpen(open);
        this.field_11863.method_8396(null, this.method_11016(), this.isLidOpen() ? class_3417.field_14664 : class_3417.field_14541, class_3419.field_15245, 0.5f, 0.4f / (this.field_11863.method_8409().method_43057() * 0.4f + 0.8f));
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        this.method_5431();
    }

    public boolean isLidOpen() {
        return this.lidOpen;
    }

    public boolean isChangeCassetteTape() {
        return this.changeCassetteTape;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    protected class_2561 method_17823() {
        return ((class_2248)IMPBlocks.CASSETTE_DECK.get()).method_9518();
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new CassetteDeckMenu(i, inventory, this.method_11016(), (class_1263)this);
    }

    public boolean method_5437(int i, class_1799 itemStack) {
        if (i == 0) {
            return IMPItemUtil.isCassetteTape(itemStack);
        }
        return super.method_5437(i, itemStack);
    }

    public Music getMusic() {
        return this.music;
    }

    public class_1799 getCassetteTape() {
        return this.method_5438(0);
    }

    public class_1799 getOldCassetteTape() {
        return this.oldCassetteTape;
    }

    protected void onCassetteTapeChange(class_1799 newItem, class_1799 oldItem) {
        if (this.monitor == MonitorType.WRITE_EXECUTION) {
            this.setMonitor(MonitorType.WRITE);
        }
        this.setRingerPosition(0L);
        this.setPlaying(false);
        this.oldCassetteTape = oldItem;
        this.changeCassetteTape = true;
    }

    public void setMusic(Music music) {
        this.music = music;
        this.method_5431();
    }

    public int getCassetteWriteProgressAll() {
        return 200;
    }

    public void setMonitor(MonitorType monitor) {
        this.monitor = monitor;
        this.method_5431();
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, class_2487 data) {
        if ("monitor".equals(name)) {
            this.monitor = MonitorType.getByName(data.method_10558("name"));
            if (this.monitor == MonitorType.WRITE_EXECUTION && this.canWriteCassetteTape()) {
                IMPCriteriaTriggers.WRITE_CASSETTE_TAPE.trigger(player, this.getCassetteTape());
            }
            return null;
        }
        if ("select_playlist".equals(name)) {
            if (data.method_10545("uuid")) {
                UUID uuid = data.method_25926("uuid");
                MusicPlayList pl = MusicManager.getInstance().getSaveData(this.getRingerLevel().method_8503()).getPlayLists().get(uuid);
                if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly()) {
                    this.setPlayerSelectPlayList(player, uuid);
                }
            } else {
                this.setPlayerSelectPlayList(player, null);
            }
            return null;
        }
        if ("set_music".equals(name)) {
            MusicPlayList pl;
            MusicManager mm;
            Music m;
            if (data.method_10545("music") && (m = (mm = MusicManager.getInstance()).getSaveData(this.getRingerLevel().method_8503()).getMusics().get(data.method_25926("music"))) != null && (pl = mm.getPlaylistByMusic(this.getRingerLevel().method_8503(), m.getUuid())) != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly()) {
                this.setMusic(m);
            }
            return null;
        }
        if ("set_volume".equals(name)) {
            if (this.isPowered()) {
                this.setVolume(data.method_10550("volume"));
            }
        } else if ("set_mute".equals(name)) {
            if (this.isPowered()) {
                this.setMute(data.method_10577("mute"));
            }
        } else if ("set_playing".equals(name)) {
            if (this.isPowered()) {
                boolean pl = data.method_10577("playing");
                this.setPlaying(pl);
                if (!pl) {
                    this.setRingerPosition(0L);
                }
            }
        } else if ("set_pause".equals(name)) {
            if (this.isPowered()) {
                this.setPlaying(false);
            }
        } else {
            if ("restat_and_set_position".equals(name)) {
                if (this.isPowered()) {
                    this.setMusicPositionAndRestart(data.method_10537("position"));
                }
                return null;
            }
            if ("set_loop".equals(name) && this.isPowered()) {
                this.setLoop(data.method_10577("loop"));
            }
        }
        return super.onInstruction(player, name, data);
    }

    public void setMusicPositionAndRestart(long position) {
        this.setRingerPosition(position);
        this.ringerRestart();
    }

    @Override
    public class_2561 getRingerName() {
        return this.method_17823();
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218)this.field_11863;
    }

    @Override
    public UUID getRingerUUID() {
        return this.ringerUUID;
    }

    @Override
    public boolean exists() {
        if (this.method_10997() == null || this.field_11863 != this.method_10997()) {
            return false;
        }
        return this.method_11016() != null && this.field_11863.method_8321(this.method_11016()) == this;
    }

    @Override
    public boolean isRingerPlaying() {
        return this.isPlaying();
    }

    @Override
    public void setRingerPlaying(boolean playing) {
        this.setPlaying(playing);
    }

    private boolean hasCassetteTape() {
        return !this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    private boolean hasMusicCassetteTape() {
        return this.hasCassetteTape() && CassetteTapeItem.getMusic(this.getCassetteTape()) != null;
    }

    @Override
    @Nullable
    public MusicSource getRingerMusicSource() {
        return this.hasMusicCassetteTape() ? CassetteTapeItem.getMusic(this.getCassetteTape()).getSource() : null;
    }

    @Override
    public boolean isRingerLoop() {
        return this.isLoop();
    }

    @Override
    public long getRingerPosition() {
        return this.getPosition();
    }

    @Override
    public void setRingerPosition(long position) {
        MusicSource m;
        this.setPosition(position);
        if (this.hasMusicCassetteTape() && (m = this.getRingerMusicSource()) != null) {
            class_1799 nc = CassetteTapeItem.setTapePercentage(this.getCassetteTape().method_7972(), (float)position / (float)m.getDuration());
            this.setItemNoChange(0, nc);
        }
        this.method_5431();
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
        return IMPMusicTrackers.createFixedTracker(this.getRingerSpatialPosition(), this.getRingerVolume(), this.getRingerRange());
    }

    @Override
    @NotNull
    public class_243 getRingerSpatialPosition() {
        return new class_243((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5);
    }

    public float getRawVolume() {
        return (float)this.getVolume() / 300.0f;
    }

    @Override
    public float getRingerVolume() {
        if (this.isRingerMute()) {
            return 0.0f;
        }
        return this.getRawVolume();
    }

    @Override
    public float getRingerRange() {
        if (this.isRingerMute()) {
            return 0.0f;
        }
        return 90.0f * this.getRawVolume();
    }

    @Override
    public boolean isRingerStream() {
        return false;
    }

    @Override
    public boolean isRingerMute() {
        return this.isMute();
    }

    public static enum MonitorType {
        OFF("off"),
        MENU("menu"),
        WRITE("write"),
        PLAYBACK("playback"),
        WRITE_EXECUTION("write_execution");

        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }
    }
}

