/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.IMPButton;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7919;

public abstract class SortButton
extends IMPButton
implements IIMPSmartRender {
    protected final boolean longed;

    private SortButton(int x, int y, int w, int tx, class_2561 component, class_4185.class_4241 onPress, boolean longed, class_437 screen) {
        super(x, y, w, 9, component, onPress);
        this.longed = longed;
    }

    public void method_25306() {
        this.cycle();
        this.method_47400(class_7919.method_47407((class_2561)this.getToolTipComponent()));
        super.method_25306();
    }

    public void method_25359(class_4587 poseStack, int mx, int my, float f) {
        this.drawSmartButtonBox(poseStack, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.method_25367());
    }

    public abstract void cycle();

    public abstract class_2561 getToolTipComponent();

    public static class OrderTypeButton
    extends SortButton {
        private OrderType type = OrderType.DESCENDING;

        public OrderTypeButton(int x, int y, class_4185.class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 88 : 9, longed ? 158 : 52, (class_2561)class_2561.method_43471((String)"imp.button.order"), onPress, longed, screen);
            if (!longed) {
                this.method_47400(class_7919.method_47407((class_2561)this.getToolTipComponent()));
            }
        }

        @Override
        public void cycle() {
            this.type = OrderType.values()[(this.type.ordinal() + 1) % OrderType.values().length];
        }

        @Override
        public class_2561 getToolTipComponent() {
            return this.type.getComponentName();
        }

        public OrderType getOrderType() {
            return this.type;
        }

        @Override
        public void method_25359(class_4587 poseStack, int mx, int my, float f) {
            super.method_25359(poseStack, mx, my, f);
            OERenderUtils.drawTexture((class_2960)MusicManagerMonitor.WIDGETS_TEXTURE, (class_4587)poseStack, (float)(this.method_46426() + 1), (float)(this.method_46427() + 1), (float)(73 + this.getOrderType().ordinal() * 7), (float)7.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(poseStack, this.getToolTipComponent(), this.method_46426() + 9, this.method_46427() + 1);
            }
        }
    }

    public static class SortTypeButton
    extends SortButton {
        private SortType type = SortType.NAME;

        public SortTypeButton(int x, int y, class_4185.class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 97 : 9, longed ? 61 : 52, (class_2561)class_2561.method_43471((String)"imp.button.sort"), onPress, longed, screen);
            if (!longed) {
                this.method_47400(class_7919.method_47407((class_2561)this.getToolTipComponent()));
            }
        }

        @Override
        public void cycle() {
            this.type = SortType.values()[(this.type.ordinal() + 1) % SortType.values().length];
        }

        @Override
        public class_2561 getToolTipComponent() {
            return this.type.getComponentName();
        }

        public SortType getSortType() {
            return this.type;
        }

        public <T extends IIMPComparable> List<T> sort(List<T> target, OrderTypeButton orderTypeButton) {
            return target.stream().sorted(this.getSortType().getComparator(orderTypeButton.getOrderType())).toList();
        }

        @Override
        public void method_25359(class_4587 poseStack, int mx, int my, float f) {
            super.method_25359(poseStack, mx, my, f);
            OERenderUtils.drawTexture((class_2960)MusicManagerMonitor.WIDGETS_TEXTURE, (class_4587)poseStack, (float)(this.method_46426() + 1), (float)(this.method_46427() + 1), (float)(73 + this.getSortType().ordinal() * 7), (float)0.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(poseStack, this.getToolTipComponent(), this.method_46426() + 9, this.method_46427() + 1);
            }
        }
    }

    public static enum OrderType {
        ASCENDING("ascending", false),
        DESCENDING("descending", true);

        private final String name;
        private final boolean reverse;
        private final class_2561 componentName;

        private OrderType(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
            this.componentName = class_2561.method_43471((String)("imp.orderType." + name));
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getComponentName() {
            return this.componentName;
        }
    }

    public static enum SortType {
        NAME("name", (o1, o2) -> o1.getCompareName().compareTo(o2.getCompareName())),
        PLAYER("player", (o1, o2) -> o1.getComparePlayerName().compareTo(o2.getComparePlayerName())),
        CREATE_DATE("create_date", (o1, o2) -> (int)(o1.getCompareDate() - o2.getCompareDate()));

        private final String name;
        private final Comparator<IIMPComparable> comparator;
        private final Comparator<IIMPComparable> rcomparator;
        private final class_2561 componentName;

        private SortType(String name, Comparator<IIMPComparable> comparator) {
            this.name = name;
            this.comparator = comparator;
            this.rcomparator = comparator.reversed();
            this.componentName = class_2561.method_43471((String)("imp.sortType." + name));
        }

        public String getName() {
            return this.name;
        }

        public Comparator<IIMPComparable> getComparator(OrderType orderType) {
            return orderType.isReverse() ? this.rcomparator : this.comparator;
        }

        public class_2561 getComponentName() {
            return this.componentName;
        }
    }
}

