/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlayBackFiniteBaseBMMonitor;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.IMPItemUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaybackBMonitor
extends PlayBackFiniteBaseBMMonitor {
    private static final class_2561 NO_ANTENNA_TEXT = class_2561.method_43471((String)"imp.text.noAntenna");
    private static final class_2561 NO_CASSETTE_TAPE_TEXT = class_2561.method_43471((String)"imp.text.noCassetteTape");
    private static final class_2561 NO_MUSIC_CASSETTE_TAPE_TEXT = class_2561.method_43471((String)"imp.text.noMusicCassetteTape");

    public PlaybackBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    @NotNull
    protected ImageInfo getPlayBackImage(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected String getPlayBackName(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getName();
        }
        return "";
    }

    @Override
    @NotNull
    protected String getPlayBackAuthor(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getAuthor();
        }
        return "";
    }

    @Nullable
    protected Music getMusic(BoomboxData data) {
        class_1799 tape = data.getCassetteTape();
        if (IMPItemUtil.isCassetteTape(tape)) {
            return CassetteTapeItem.getMusic(tape);
        }
        return null;
    }

    @Override
    protected boolean canPlay(BoomboxData data) {
        return IMPItemUtil.isCassetteTape(data.getCassetteTape()) && this.getMusic(data) != null;
    }

    @Override
    @NotNull
    protected MusicSource getPlayBackSource(BoomboxData data) {
        Music m = this.getMusic(data);
        if (m != null) {
            return m.getSource();
        }
        return MusicSource.EMPTY;
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.getScreen().lastNoAntenna = 0L;
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        if (!this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            Music music = CassetteTapeItem.getMusic(this.getCassetteTape());
            if (music == null) {
                this.drawSmartCenterText(poseStack, NO_MUSIC_CASSETTE_TAPE_TEXT, (float)this.getStartX() + (float)this.width / 2.0f, (float)this.getStartY() + ((float)this.height - 10.0f) / 2.0f);
            }
        } else {
            this.drawSmartCenterText(poseStack, NO_CASSETTE_TAPE_TEXT, (float)this.getStartX() + (float)this.width / 2.0f, (float)this.getStartY() + ((float)this.height - 10.0f) / 2.0f);
        }
        long noAntennaTime = System.currentTimeMillis() - this.getScreen().lastNoAntenna;
        if (noAntennaTime <= 3000L) {
            float alpha = Math.min(3.0f - (float)noAntennaTime / 3000.0f * 3.0f, 1.0f);
            int ad = (int)(255.0f * alpha);
            float fl = (float)PlaybackBMonitor.mc.field_1772.method_27525((class_5348)NO_ANTENNA_TEXT) + 6.0f;
            float st = ((float)this.width - fl) / 2.0f;
            float sy = ((float)this.height - 10.0f) / 2.0f;
            this.drawFill(poseStack, (int)((float)this.getStartX() + st), (int)((float)this.getStartY() + sy), (int)fl, 10, 0xA9A9A9 | ad << 24);
            this.drawSmartText(poseStack, NO_ANTENNA_TEXT, (float)this.getStartX() + st + 3.0f, (float)this.getStartY() + sy + 1.0f, Math.max(ad, 5) << 24);
        }
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        class_1799 cassetteTape = data.getCassetteTape();
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        if (!cassetteTape.method_7960() && IMPItemUtil.isCassetteTape(cassetteTape)) {
            Music music = CassetteTapeItem.getMusic(cassetteTape);
            if (music == null) {
                this.renderSmartCenterTextSprite(poseStack, multiBufferSource, NO_MUSIC_CASSETTE_TAPE_TEXT, (float)this.width / 2.0f, ((float)this.height - 10.0f) / 2.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
            }
        } else {
            this.renderSmartCenterTextSprite(poseStack, multiBufferSource, NO_CASSETTE_TAPE_TEXT, (float)this.width / 2.0f, ((float)this.height - 10.0f) / 2.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        }
    }
}

