/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.planner;

import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.CombinedIpBlock;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpAddressTools;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.felnull.imp.include.org.apache.http.HttpException;
import dev.felnull.imp.include.org.apache.http.HttpHost;
import dev.felnull.imp.include.org.apache.http.HttpRequest;
import dev.felnull.imp.include.org.apache.http.ProtocolException;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.conn.SchemePortResolver;
import dev.felnull.imp.include.org.apache.http.conn.UnsupportedSchemeException;
import dev.felnull.imp.include.org.apache.http.conn.routing.HttpRoute;
import dev.felnull.imp.include.org.apache.http.conn.routing.HttpRoutePlanner;
import dev.felnull.imp.include.org.apache.http.impl.conn.DefaultSchemePortResolver;
import dev.felnull.imp.include.org.apache.http.protocol.HttpContext;
import dev.felnull.imp.include.org.apache.http.util.Args;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRoutePlanner
implements HttpRoutePlanner {
    private static final String CHOSEN_IP_ATTRIBUTE = "yt-route-ip";
    private static final long FAILING_TIME = TimeUnit.DAYS.toMillis(7L);
    private static final Logger log = LoggerFactory.getLogger(AbstractRoutePlanner.class);
    protected final IpBlock ipBlock;
    protected final Map<String, Long> failingAddresses;
    private final SchemePortResolver schemePortResolver;
    private final boolean handleSearchFailure;

    protected AbstractRoutePlanner(List<IpBlock> ipBlocks, boolean handleSearchFailure) {
        this.ipBlock = new CombinedIpBlock(ipBlocks);
        this.failingAddresses = new HashMap<String, Long>();
        this.schemePortResolver = DefaultSchemePortResolver.INSTANCE;
        this.handleSearchFailure = handleSearchFailure;
        log.info("Active RoutePlanner: {} using total of {} ips", (Object)this.getClass().getCanonicalName(), (Object)this.ipBlock.getSize());
    }

    public IpBlock getIpBlock() {
        return this.ipBlock;
    }

    public boolean shouldHandleSearchFailure() {
        return this.handleSearchFailure;
    }

    public Map<String, Long> getFailingAddresses() {
        return this.failingAddresses;
    }

    public final InetAddress getLastAddress(HttpClientContext context) {
        return context.getAttribute(CHOSEN_IP_ATTRIBUTE, InetAddress.class);
    }

    public final void markAddressFailing(HttpClientContext context) {
        InetAddress address = this.getLastAddress(context);
        if (address == null) {
            log.warn("Call to markAddressFailing() without chosen IP set", new RuntimeException("Report this to the devs: address is null"));
            return;
        }
        this.failingAddresses.put(address.toString(), System.currentTimeMillis());
        this.onAddressFailure(address);
    }

    public final void freeAddress(InetAddress address) {
        this.failingAddresses.remove(address.toString());
    }

    public final void freeAllAddresses() {
        this.failingAddresses.clear();
    }

    protected final boolean isValidAddress(InetAddress address) {
        Long failedTimestamp = this.failingAddresses.get(address.toString());
        if (failedTimestamp == null) {
            log.debug("No failing entry for {}", (Object)address);
            return true;
        }
        if (failedTimestamp + this.getFailingIpsCacheDuration() < System.currentTimeMillis()) {
            this.failingAddresses.remove(address.toString());
            log.debug("Removing expired failing entry for {}", (Object)address);
            return true;
        }
        log.warn("{} was chosen, but is marked as failing, retrying...", (Object)address);
        return false;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        int remotePort;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        if (host.getPort() <= 0) {
            try {
                remotePort = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException e) {
                throw new HttpException(e.getMessage());
            }
        } else {
            remotePort = host.getPort();
        }
        Tuple<Inet4Address, Inet6Address> remoteAddresses = IpAddressTools.getRandomAddressesFromHost(host);
        Tuple<InetAddress, InetAddress> addresses = this.determineAddressPair(remoteAddresses);
        HttpHost target = new HttpHost((InetAddress)addresses.r, host.getHostName(), remotePort, host.getSchemeName());
        HttpHost proxy = config.getProxy();
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        clientContext.setAttribute(CHOSEN_IP_ATTRIBUTE, addresses.l);
        log.debug("Setting route context attribute to {}", addresses.l);
        if (proxy == null) {
            return new HttpRoute(target, (InetAddress)addresses.l, secure);
        }
        return new HttpRoute(target, (InetAddress)addresses.l, proxy, secure);
    }

    protected void onAddressFailure(InetAddress address) {
    }

    protected long getFailingIpsCacheDuration() {
        return FAILING_TIME;
    }

    protected abstract Tuple<InetAddress, InetAddress> determineAddressPair(Tuple<Inet4Address, Inet6Address> var1) throws HttpException;
}

