/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.otyacraftengine.advancement.ModInvolvementTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class MusicRing {
    private final class_3218 level;
    private final Map<UUID, IMusicRinger> ringers = new HashMap<UUID, IMusicRinger>();
    private final Map<UUID, RingedPlayerInfos> playerInfos = new HashMap<UUID, RingedPlayerInfos>();
    private final Set<UUID> waitRingers = new HashSet<UUID>();
    private long baseTime;
    private long pauseTime = -1L;
    private long lastTime;

    public MusicRing(class_3218 level) {
        this.level = level;
        this.baseTime = System.currentTimeMillis();
        this.lastTime = this.getTime();
    }

    private class_3218 getLevel() {
        return this.level;
    }

    protected void tick() {
        ArrayList<UUID> stopRingers = new ArrayList<UUID>();
        for (IMusicRinger ringer : this.ringers.values()) {
            UUID uuid = ringer.getRingerUUID();
            if (!ringer.exists()) {
                stopRingers.add(uuid);
                continue;
            }
            MusicSource ms = ringer.getRingerMusicSource();
            if (ms == null || !ringer.isRingerPlaying()) {
                ringer.setRingerPlaying(false);
                this.stopRingingPlayer(uuid);
                continue;
            }
            RingedPlayerInfos rpi = this.playerInfos.get(uuid);
            if (rpi == null) {
                rpi = new RingedPlayerInfos(uuid, this.getTime());
                rpi.sendFirstPackets();
                this.playerInfos.put(uuid, rpi);
                this.waitRingers.add(uuid);
            }
            if (!rpi.tick(this.getTime())) continue;
            this.waitRingers.remove(uuid);
            long eq = this.getTime() - this.lastTime;
            if (ms.getDuration() >= ringer.getRingerPosition() + eq || ringer.isRingerStream()) {
                MusicSource sc = ringer.getRingerMusicSource();
                ringer.setRingerPosition(class_3532.method_24156((long)(ringer.getRingerPosition() + eq), (long)0L, (long)(sc != null ? sc.getDuration() : 0L)));
                continue;
            }
            ringer.setRingerPosition(0L);
            ringer.ringerEnd();
            if (ringer.isRingerLoop()) {
                this.stopRingingPlayer(uuid);
                continue;
            }
            ringer.setRingerPlaying(false);
        }
        stopRingers.forEach(this::stopRinger);
        this.lastTime = this.getTime();
    }

    protected boolean isWaitRinger(UUID ringer) {
        return this.waitRingers.contains(ringer);
    }

    protected void addRinger(IMusicRinger ringer) {
        if (!this.ringers.containsKey(ringer.getRingerUUID())) {
            this.ringers.put(ringer.getRingerUUID(), ringer);
        }
    }

    public boolean hasRinger(UUID ringer) {
        return this.ringers.containsKey(ringer);
    }

    public Map<UUID, IMusicRinger> getRingers() {
        return this.ringers;
    }

    protected void pause() {
        this.pauseTime = System.currentTimeMillis();
    }

    protected void resume() {
        if (this.pauseTime >= 0L) {
            this.baseTime += System.currentTimeMillis() - this.pauseTime;
        }
        this.pauseTime = 0L;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.baseTime;
    }

    protected void depose() {
        this.ringers.clear();
        this.playerInfos.clear();
        this.waitRingers.clear();
    }

    protected void restart(UUID uuid) {
        IMusicRinger ringer = this.ringers.get(uuid);
        if (ringer != null) {
            this.stopRinger(uuid);
            this.addRinger(ringer);
        }
    }

    protected void stopRinger(UUID ringer) {
        this.ringers.remove(ringer);
        this.waitRingers.remove(ringer);
        if (this.playerInfos.containsKey(ringer)) {
            this.playerInfos.get(ringer).depose();
            this.playerInfos.remove(ringer);
        }
    }

    protected void stopRingingPlayer(UUID ringer) {
        this.waitRingers.remove(ringer);
        if (this.playerInfos.containsKey(ringer)) {
            this.playerInfos.get(ringer).depose();
            this.playerInfos.remove(ringer);
        }
    }

    private MusicTrackerEntry getMusicTracker(IMusicRinger ringer) {
        return ringer.getRingerTracker();
    }

    protected void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, IMPPackets.MusicRingResponseStateType state) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.infoUUID.equals(waitUUID)) {
            pr.responseUpdate(player, state);
        }
    }

    protected void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.infoUUID.equals(waitUUID)) {
            long st = this.getTime() - pr.startTime;
            if (st > MusicRing.getMaxWaitTime()) {
                elapsed -= MusicRing.getMaxWaitTime();
            }
            pr.addReadyPlayer(player, result, retry, elapsed);
        }
    }

    public static long getMaxWaitTime() {
        return IamMusicPlayer.CONFIG.maxWaitTime;
    }

    public static long getRetryTime() {
        return IamMusicPlayer.CONFIG.retryTime;
    }

    private class RingedPlayerInfos {
        private final UUID ringerUUID;
        private final UUID infoUUID = UUID.randomUUID();
        private final List<UUID> firstWaitPlayers = new ArrayList<UUID>();
        private final List<UUID> firstReadyPlayers = new ArrayList<UUID>();
        private final List<UUID> listenPlayers = new ArrayList<UUID>();
        private final List<UUID> middleLoadPlayers = new ArrayList<UUID>();
        private final Map<UUID, Long> failurePlayers = new HashMap<UUID, Long>();
        private final long startTime;
        private boolean notWait;

        public RingedPlayerInfos(UUID ringer, long startTime) {
            this.ringerUUID = ringer;
            this.startTime = startTime;
            this.firstWaitPlayers.addAll(MusicRing.this.getLevel().method_18456().stream().filter(this::canListen).map(n -> n.method_7334().getId()).toList());
        }

        private void sendFirstPackets() {
            for (UUID firstWaitPlayer : this.firstWaitPlayers) {
                class_1657 class_16572 = MusicRing.this.getLevel().method_18470(firstWaitPlayer);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_READY, (class_2540)new IMPPackets.MusicReadyMessage(this.infoUUID, this.ringerUUID, this.getRinger().getRingerMusicSource(), MusicRing.this.getMusicTracker(this.getRinger()).saveToTag(), this.getRingerPosition()).toFBB());
            }
        }

        private void sendStopPackets(UUID player) {
            class_1657 class_16572 = MusicRing.this.getLevel().method_18470(player);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, IMPPackets.MusicRingStateType.STOP).toFBB());
            }
        }

        private void sendMiddleStartPacket(UUID player) {
            class_1657 class_16572 = MusicRing.this.getLevel().method_18470(player);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_READY, (class_2540)new IMPPackets.MusicReadyMessage(this.infoUUID, this.ringerUUID, this.getRinger().getRingerMusicSource(), MusicRing.this.getMusicTracker(this.getRinger()).saveToTag(), this.getRingerPosition()).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private long getRingerPosition() {
            if (this.getRinger().isRingerStream()) {
                return 0L;
            }
            MusicSource sc = this.getRinger().getRingerMusicSource();
            return class_3532.method_24156((long)this.getRinger().getRingerPosition(), (long)0L, (long)(sc != null ? sc.getDuration() : 0L));
        }

        private void addReadyPlayer(class_3222 player, boolean result, boolean retry, long elapsed) {
            UUID id = player.method_7334().getId();
            if (this.notWait) {
                if (this.middleLoadPlayers.contains(id)) {
                    if (result) {
                        NetworkManager.sendToPlayer((class_3222)player, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, IMPPackets.MusicRingStateType.PLAY, this.getRinger().isRingerStream() ? 0L : elapsed, MusicRing.this.getMusicTracker(this.getRinger()).saveToTag()).toFBB());
                        this.listenPlayers.add(id);
                    } else {
                        this.failurePlayers.put(id, System.currentTimeMillis());
                    }
                    this.middleLoadPlayers.remove(id);
                }
            } else {
                if (result) {
                    this.listenPlayers.add(id);
                    this.firstReadyPlayers.add(id);
                } else {
                    this.failurePlayers.put(id, System.currentTimeMillis());
                }
                this.firstWaitPlayers.remove(id);
            }
        }

        private void startReadyWaitPlayers() {
            for (UUID pl : this.firstReadyPlayers) {
                class_1657 class_16572 = MusicRing.this.getLevel().method_18470(pl);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, IMPPackets.MusicRingStateType.PLAY, 0L, MusicRing.this.getMusicTracker(this.getRinger()).saveToTag()).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private void responseUpdate(class_3222 player, IMPPackets.MusicRingResponseStateType state) {
            UUID id = player.method_7334().getId();
            if (this.listenPlayers.contains(id)) {
                if (state != IMPPackets.MusicRingResponseStateType.PLAYING) {
                    this.listenPlayers.remove(id);
                }
                if (state == IMPPackets.MusicRingResponseStateType.LOADING) {
                    this.sendStopPackets(id);
                }
            }
            if (this.middleLoadPlayers.contains(id) && state != IMPPackets.MusicRingResponseStateType.LOADING) {
                this.middleLoadPlayers.remove(id);
            }
        }

        private void sendUpdate() {
            class_3222 serverPlayer;
            class_1657 class_16572;
            for (UUID player : this.listenPlayers) {
                class_16572 = MusicRing.this.getLevel().method_18470(player);
                if (!(class_16572 instanceof class_3222)) continue;
                serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, IMPPackets.MusicRingStateType.UPDATE, 0L, MusicRing.this.getMusicTracker(this.getRinger()).saveToTag()).toFBB());
            }
            for (UUID player : this.middleLoadPlayers) {
                class_16572 = MusicRing.this.getLevel().method_18470(player);
                if (!(class_16572 instanceof class_3222)) continue;
                serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, IMPPackets.MusicRingStateType.UPDATE, 0L, MusicRing.this.getMusicTracker(this.getRinger()).saveToTag()).toFBB());
            }
        }

        private boolean tick(long currentTime) {
            if (this.notWait) {
                ArrayList<UUID> nl = new ArrayList<UUID>();
                for (class_3222 player : MusicRing.this.getLevel().method_18456()) {
                    UUID id;
                    if (!this.canListen((class_1657)player) || this.isFailureCoolDown(id = player.method_7334().getId())) continue;
                    nl.add(id);
                    if (this.listenPlayers.contains(id) || this.middleLoadPlayers.contains(id)) continue;
                    this.sendMiddleStartPacket(id);
                    this.middleLoadPlayers.add(id);
                }
                for (UUID listenPlayer : this.listenPlayers) {
                    if (nl.contains(listenPlayer)) continue;
                    this.sendStopPackets(listenPlayer);
                }
                for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                    if (nl.contains(middleLoadPlayer)) continue;
                    this.sendStopPackets(middleLoadPlayer);
                }
                this.listenPlayers.clear();
                this.listenPlayers.addAll(nl.stream().filter(n -> !this.middleLoadPlayers.contains(n)).toList());
                this.middleLoadPlayers.clear();
                this.middleLoadPlayers.addAll(nl.stream().filter(n -> !this.listenPlayers.contains(n)).toList());
                this.sendUpdate();
                return true;
            }
            if (this.canPlayPlayersCheck(currentTime)) {
                this.startReadyWaitPlayers();
                this.notWait = true;
                return true;
            }
            return false;
        }

        private boolean isFailureCoolDown(UUID player) {
            Long fr = this.failurePlayers.get(player);
            if (fr != null) {
                return System.currentTimeMillis() - fr <= MusicRing.getRetryTime();
            }
            return false;
        }

        private boolean canPlayPlayersCheck(long currentTime) {
            long eq = currentTime - this.startTime;
            if (eq > MusicRing.getMaxWaitTime()) {
                return true;
            }
            ArrayList<UUID> removes = new ArrayList<UUID>();
            for (UUID waiter : this.firstWaitPlayers) {
                class_1657 pl = MusicRing.this.getLevel().method_18470(waiter);
                if (pl != null && this.canListen(pl)) continue;
                removes.add(waiter);
            }
            this.firstWaitPlayers.removeAll(removes);
            return this.firstWaitPlayers.isEmpty();
        }

        private void advancement(class_3222 player) {
            IMPCriteriaTriggers.LISTEN_TO_MUSIC.trigger(player, this.getRinger().isRingerStream(), this.getRinger().isRingerRemote(), this.isKamesuta());
            ModInvolvementTrigger.trigger((class_3222)player, (String)"iammusicplayer");
        }

        private boolean isKamesuta() {
            String ath = this.getRinger().getRingerMusicAuthor();
            return this.getRinger().getRingerAntenna().method_7964().getString().equalsIgnoreCase("kamesuta") && ath != null && (ath.equalsIgnoreCase("kamesuta") || ath.equalsIgnoreCase("\u304b\u3081\u3059\u305f") || ath.equalsIgnoreCase("\u30ab\u30e1\u30b9\u30bf"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean canListen(class_1657 player) {
            if (player.field_6002 != MusicRing.this.getLevel()) return false;
            double d = Math.sqrt(player.method_5707(this.getRinger().getRingerSpatialPosition()));
            float f = this.getRinger().isRingerMute() ? 0.0f : this.getRinger().getRingerRange() + 30.0f;
            if (!(d <= (double)f)) return false;
            return true;
        }

        private IMusicRinger getRinger() {
            return MusicRing.this.ringers.get(this.ringerUUID);
        }

        private void depose() {
            for (UUID listenPlayer : this.listenPlayers) {
                this.sendStopPackets(listenPlayer);
            }
            for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                this.sendStopPackets(middleLoadPlayer);
            }
            for (UUID listenPlayer : this.firstReadyPlayers) {
                this.sendStopPackets(listenPlayer);
            }
            for (UUID listenPlayer : this.firstWaitPlayers) {
                this.sendStopPackets(listenPlayer);
            }
        }
    }
}

