package dev.felnull.imp.block;

import Buttons;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import record;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class BoomboxData {
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<>();
    private final DataAccess access;
    private MonitorType monitorType = MonitorType.OFF;
    private MonitorType lastMonitorType = MonitorType.OFF;
    private boolean handleRaising = true;
    private boolean lidOpen;
    private int handleRaisedProgressOld = getHandleRaisedMax();
    private int handleRaisedProgress = getHandleRaisedMax();
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int parabolicAntennaProgressOld;
    private int parabolicAntennaProgress;
    private int antennaProgressOld;
    private int antennaProgress;
    private class_1799 oldCassetteTape = class_1799.field_8037;
    private boolean oldCassetteTapeFlg;
    private boolean changeCassetteTape;
    private boolean playing;
    private int volume = 150;
    private boolean loop;
    private boolean mute;
    private long musicPosition;
    private boolean loadingMusic;
    private String radioUrl = "";
    private MusicSource radioSource = MusicSource.EMPTY;
    private ImageInfo radioImage = ImageInfo.EMPTY;
    private String radioName = "";
    private String radioAuthor = "";
    private Music selectedMusic;
    private ContinuousType continuousType = ContinuousType.NONE;
    private boolean radioStartFlg;
    private boolean noChangeCassetteTape;

    public BoomboxData(class_2487 boomboxTag, @NotNull BoomboxData.DataAccess access) {
        this.access = access;
        if (boomboxTag != null) this.load(boomboxTag.method_10562("BoomBoxData"), true, true);
    }

    public void tick(class_1937 level) {

        this.handleRaisedProgressOld = this.handleRaisedProgress;
        this.lidOpenProgressOld = this.lidOpenProgress;
        this.antennaProgressOld = this.antennaProgress;
        this.parabolicAntennaProgressOld = this.parabolicAntennaProgress;

        if (this.handleRaising)
            this.handleRaisedProgress = class_3532.method_15340(this.handleRaisedProgress + 1, 0, getHandleRaisedMax());
        else this.handleRaisedProgress = class_3532.method_15340(this.handleRaisedProgress - 1, 0, getHandleRaisedMax());

        if (this.lidOpen) this.lidOpenProgress = class_3532.method_15340(this.lidOpenProgress + 1, 0, getLidOpenProgressMax());
        else this.lidOpenProgress = class_3532.method_15340(this.lidOpenProgress - 1, 0, getLidOpenProgressMax());

        if (isUseAntenna() && isRadioStream()) this.antennaProgress = class_3532.method_15340(this.antennaProgress + 1, 0, 30);
        else this.antennaProgress = class_3532.method_15340(this.antennaProgress - 1, 0, 30);

        if (isPowered() && isUseAntenna() && isAntennaExist() && getAntenna().method_31574(IMPItems.PARABOLIC_ANTENNA.get()))
            this.parabolicAntennaProgress += 2;


        if (!level.method_8608()) {
            if (getRinger() != null) loadingMusic = getRinger().isRingerWait();

            if (isPowered() && monitorType == MonitorType.OFF) monitorType = MonitorType.PLAYBACK;

            if (!isPowered() && monitorType != MonitorType.OFF) monitorType = MonitorType.OFF;

            if (monitorType != lastMonitorType) {
                lastMonitorType = monitorType;
                setMusicPosition(0);
                setPlaying(false);
            }

            if (!canPlay()) {
                setMusicPosition(0);
                setPlaying(false);
            }

            if (!isRadioRemote()) {
                playerSelectPlaylists.clear();
                setSelectedMusic(null);
                setContinuousType(ContinuousType.NONE);
            }

            if (radioStartFlg) {
                setRadioStartFlg(false);
                setPlaying(true);
            }

            if (monitorType == MonitorType.REMOTE_PLAYBACK && getSelectedMusic() == null)
                monitorType = MonitorType.REMOTE_PLAYBACK_SELECT;

            if (monitorType == MonitorType.RADIO && getRadioSource().isEmpty()) monitorType = MonitorType.RADIO_SELECT;

            if ((isRadio() && !isAntennaExist()) || (isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) || (isRadioStream() && IMPItemUtil.isRemotePlayBackAntenna(getAntenna())))

                if ((isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) || (isRadioStream() && !IMPItemUtil.isRadioAntenna(getAntenna()))) {
                    monitorType = MonitorType.PLAYBACK;
                }

            if (!isRadioStream()) {
                setRadioImage(ImageInfo.EMPTY);
                setRadioSource(MusicSource.EMPTY);
                setRadioAuthor("");
                setRadioName("");
                setRadioUrl("");
            }

            if (monitorType != MonitorType.RADIO_SELECT) setRadioUrl("");

            if (this.changeCassetteTape) {
                if (!isLidOpen()) startLidOpen(true, level);

                if (getLidOpenProgress() >= getLidOpenProgressMax()) {
                    changeCassetteTape = false;
                    startLidOpen(false, level);
                }
            }
        }
    }

    public boolean canPlay() {
        boolean canPlayFlg = monitorType == MonitorType.PLAYBACK && isMusicCassetteTapeExist();
        boolean canPlayFlg2 = monitorType == MonitorType.RADIO && !getRadioSource().isEmpty();
        boolean canPlayFlg3 = monitorType == MonitorType.REMOTE_PLAYBACK;
        return canPlayFlg || canPlayFlg2 || canPlayFlg3;
    }

    public class_2487 onInstruction(class_3222 player, String name, class_2487 data) {
        if ("buttons_press".equals(name)) {
            ButtonType type = ButtonType.getByName(data.method_10558("Type"));
            switch (type) {
                case POWER -> setPower(!isPowered());
                case LOOP -> setLoop(!isLoop());
                case VOL_DOWN -> {
                    if (isPowered()) setVolume(class_3532.method_15340(volume - 10, 0, 300));
                }
                case VOL_UP -> {
                    if (isPowered()) setVolume(class_3532.method_15340(volume + 10, 0, 300));
                    setMute(false);
                }
                case VOL_MUTE -> setMute(!isMute());
                case VOL_MAX -> {
                    if (isPowered()) setVolume(300);
                    setMute(false);
                }
                case RADIO -> {
                    if (isRadio()) {
                        setMonitorType(MonitorType.PLAYBACK);
                    } else {
                        setPower(true);
                        setRadioMode();
                    }
                }
                case START -> {
                    if (isMusicCassetteTapeExist() || isRadio()) {
                        setPower(true);
                        setPlaying(true);
                    }
                }
                case STOP -> {
                    if (isPowered()) {
                        setPlaying(false);
                        setMusicPosition(0);
                    }
                }
                case PAUSE -> {
                    if (isPowered()) {
                        setPlaying(false);
                        if (isRadioStream()) setMusicPosition(0);
                    }
                }
            }
            return null;
        } else if ("set_volume".equals(name)) {
            if (isPowered()) setVolume(data.method_10550("volume"));
            return null;
        } else if ("set_playing".equals(name)) {
            if (isPowered()) {
                boolean pl = data.method_10577("playing");
                setPlaying(pl);
                if (!pl) setMusicPosition(0);
            }
            return null;
        } else if ("set_pause".equals(name)) {
            if (isPowered()) setPlaying(false);
            return null;
        } else if ("set_loop".equals(name)) {
            if (isPowered()) setLoop(data.method_10577("loop"));
            return null;
        } else if ("restat_and_set_position".equals(name)) {
            if (isPowered()) setMusicPositionAndRestart(data.method_10537("position"));
            return null;
        } else if ("set_radio_url".equals(name)) {
            if (isPowered()) setRadioUrl(data.method_10558("url"));
            return null;
        } else if ("set_monitor".equals(name)) {
            if (isPowered()) {
                var m = MonitorType.getByName(data.method_10558("name"));
                setMonitorType(m);
                if ((m == MonitorType.RADIO && getRadioSource() != null && !getRadioSource().isEmpty()) || (m == MonitorType.REMOTE_PLAYBACK && getSelectedMusic() != null && !getSelectedMusic().getSource().isEmpty()))
                    setRadioStartFlg(true);
            }
            return null;
        } else if ("set_radio_source".equals(name)) {
            if (isPowered())
                setRadioSource(TagSerializable.loadSavedTag(data.method_10562("source"), new MusicSource()));
            return null;
        } else if ("set_radio_image".equals(name)) {
            if (isPowered()) setRadioImage(TagSerializable.loadSavedTag(data.method_10562("image"), new ImageInfo()));
            return null;
        } else if ("set_radio_name".equals(name)) {
            if (isPowered()) setRadioName(data.method_10558("name"));
            return null;
        } else if ("set_radio_author".equals(name)) {
            if (isPowered()) setRadioAuthor(data.method_10558("author"));
            return null;
        } else if ("set_selected_play_list".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                if (data.method_10545("pl")) {
                    var uuid = data.method_25926("pl");
                    var pl = MusicManager.getInstance().getSaveData(player.field_13995).getPlayLists().get(uuid);
                    if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly())
                        setSelectedPlayList(player, uuid);
                } else {
                    setSelectedPlayList(player, null);
                }
            }
            return null;
        } else if ("set_selected_music".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                if (data.method_10545("m")) {
                    var uuid = data.method_25926("m");
                    var m = MusicManager.getInstance().getSaveData(player.field_13995).getMusics().get(uuid);
                    if (m != null) {
                        var pl = MusicManager.getInstance().getPlaylistByMusic(player.field_13995, m.getUuid());
                        if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly()) {
                            setSelectedMusic(m);
                        }
                    }
                } else {
                    setSelectedMusic(null);
                }
            }
            return null;
        } else if ("set_continuous_type".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                setContinuousType(ContinuousType.getByName(data.method_10558("type")));
            }
            return null;
        }
        return null;
    }

    public void onCassetteTapeChange(class_1799 newItem, class_1799 oldItem) {
        if (!oldCassetteTapeFlg) this.oldCassetteTape = oldItem.method_7972();
        oldCassetteTapeFlg = false;

        if (!isRadio()) {
            setMusicPosition(0);
            setPlaying(false);
        }
        if (!(newItem.method_7960() && isLidOpen())) this.changeCassetteTape = true;
        update();
    }

    public void setOldCassetteTape(class_1799 oldCassetteTape) {
        this.oldCassetteTape = oldCassetteTape;
        this.oldCassetteTapeFlg = true;
        update();
    }

    public class_2487 save(class_2487 tag, boolean absolutely, boolean sync) {
        tag.method_10582("MonitorType", this.monitorType.getName());
        tag.method_10556("HandleRaising", this.handleRaising);
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10556("Playing", playing);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("Mute", this.mute);
        tag.method_10544("RingerPosition", this.musicPosition);
        tag.method_10582("RadioUrl", this.radioUrl);
        tag.method_10566("RadioSource", this.radioSource.createSavedTag());
        tag.method_10566("RadioImage", this.radioImage.createSavedTag());
        tag.method_10582("RadioName", this.radioName);
        tag.method_10582("RadioAuthor", this.radioAuthor);
        OENbtUtils.writeUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (this.selectedMusic != null) tag.method_10566("SelectedMusic", this.selectedMusic.createSavedTag());
        tag.method_10582("ContinuousType", this.continuousType.getName());
        tag.method_10582("LastMonitorType", this.lastMonitorType.getName());


        if (absolutely) {
            tag.method_10569("HandleRaisedProgressOld", this.handleRaisedProgressOld);
            tag.method_10569("HandleRaisedProgress", this.handleRaisedProgress);
            tag.method_10569("LidOpenProgressOld", this.lidOpenProgressOld);
            tag.method_10569("LidOpenProgress", this.lidOpenProgress);
            tag.method_10569("ParabolicAntennaProgressOld", this.parabolicAntennaProgressOld);
            tag.method_10569("ParabolicAntennaProgress", this.parabolicAntennaProgress);
            tag.method_10569("AntennaProgressOld", this.antennaProgressOld);
            tag.method_10569("AntennaProgress", this.antennaProgress);
            tag.method_10556("NoChangeCassetteTape", this.noChangeCassetteTape);
        }

        if (absolutely || sync) {
            tag.method_10556("ChangeCassetteTape", this.changeCassetteTape);
            tag.method_10566("OldCassetteTape", this.oldCassetteTape.method_7953(new class_2487()));
            tag.method_10556("OldCassetteTapeFlg", oldCassetteTapeFlg);
            tag.method_10556("LoadingMusic", this.loadingMusic);
            tag.method_10556("RadioStartFlg", this.radioStartFlg);
        }

        return tag;
    }

    public void load(class_2487 tag, boolean absolutely, boolean sync) {
        this.monitorType = MonitorType.getByName(tag.method_10558("MonitorType"));
        this.handleRaising = tag.method_10577("HandleRaising");
        this.lidOpen = tag.method_10577("LidOpen");
        this.playing = tag.method_10577("Playing");
        if (tag.method_10545("Volume")) this.volume = tag.method_10550("Volume");
        this.loop = tag.method_10577("Loop");
        this.mute = tag.method_10577("Mute");
        this.musicPosition = tag.method_10537("RingerPosition");
        this.radioUrl = tag.method_10558("RadioUrl");
        this.radioSource = TagSerializable.loadSavedTag(tag.method_10562("RadioSource"), new MusicSource());
        this.radioImage = TagSerializable.loadSavedTag(tag.method_10562("RadioImage"), new ImageInfo());
        this.radioName = tag.method_10558("RadioName");
        this.radioAuthor = tag.method_10558("RadioAuthor");
        OENbtUtils.readUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        this.continuousType = ContinuousType.getByName(tag.method_10558("ContinuousType"));
        this.lastMonitorType = MonitorType.getByName(tag.method_10558("LastMonitorType"));

        if (tag.method_10545("SelectedMusic"))
            this.selectedMusic = TagSerializable.loadSavedTag(tag.method_10562("SelectedMusic"), new Music());

        if (absolutely) {
            this.handleRaisedProgressOld = tag.method_10550("HandleRaisedProgressOld");
            this.handleRaisedProgress = tag.method_10550("HandleRaisedProgress");
            this.lidOpenProgressOld = tag.method_10550("LidOpenProgressOld");
            this.lidOpenProgress = tag.method_10550("LidOpenProgress");
            this.parabolicAntennaProgressOld = tag.method_10550("ParabolicAntennaProgressOld");
            this.parabolicAntennaProgress = tag.method_10550("ParabolicAntennaProgress");
            this.antennaProgressOld = tag.method_10550("AntennaProgressOld");
            this.antennaProgress = tag.method_10550("AntennaProgress");
            this.noChangeCassetteTape = tag.method_10577("NoChangeCassetteTape");
        }

        if (absolutely || sync) {
            this.changeCassetteTape = tag.method_10577("ChangeCassetteTape");
            this.oldCassetteTape = class_1799.method_7915(tag.method_10562("OldCassetteTape"));
            this.oldCassetteTapeFlg = tag.method_10577("OldCassetteTapeFlg");
            this.loadingMusic = tag.method_10577("LoadingMusic");
            this.radioStartFlg = tag.method_10577("RadioStartFlg");
        }

        if (!sync) {
            if (this.handleRaising) this.handleRaisedProgress = getHandleRaisedMax();
            if (this.lidOpen) this.lidOpenProgress = getLidOpenProgressMax();
        }
    }

    public void setNoChangeCassetteTape(boolean noChangeCassetteTape) {
        this.noChangeCassetteTape = noChangeCassetteTape;
    }

    public boolean isNoChangeCassetteTape() {
        return noChangeCassetteTape;
    }

    public void setRadioSource(MusicSource radioSource) {
        this.radioSource = radioSource;
        update();
    }

    public void setRadioImage(ImageInfo radioImage) {
        this.radioImage = radioImage;
        update();
    }

    public MusicSource getRadioSource() {
        return radioSource;
    }

    public ImageInfo getRadioImage() {
        return radioImage;
    }

    public void setRadioUrl(String radioUrl) {
        this.radioUrl = radioUrl;
        update();
    }

    public void setRadioName(String radioName) {
        this.radioName = radioName;
        update();
    }

    public void setRadioAuthor(String radioAuthor) {
        this.radioAuthor = radioAuthor;
        update();
    }

    public String getRadioName() {
        return radioName;
    }

    public String getRadioAuthor() {
        return radioAuthor;
    }

    public String getRadioUrl() {
        return radioUrl;
    }

    public boolean isLoadingMusic() {
        return loadingMusic;
    }

    public long getMusicPosition() {
        return musicPosition;
    }

    public void setMusicPosition(long position) {
        this.musicPosition = position;
        if (isMusicCassetteTapeExist() && !isRadioRemote()) {
            var m = getMusicSource();
            if (m != null) {
                var nc = CassetteTapeItem.setTapePercentage(getCassetteTape().method_7972(), (float) position / (float) m.getDuration());
                if (!class_1799.method_7973(nc, getCassetteTape())) {
                    setCassetteTape(nc);
                }
            }
        }
        update();
    }

    public void setCassetteTape(class_1799 stack) {
        access.setCassetteTape(stack);
    }

    public MusicSource getMusicSource() {
        if (isMusicCassetteTapeExist()) {
            var m = CassetteTapeItem.getMusic(getCassetteTape());
            if (m != null) return m.getSource();
        }
        return null;
    }

    public void setMusicPositionAndRestart(long position) {
        setMusicPosition(position);
        if (getRinger() != null) {
            getRinger().ringerRestart();
            update();
        }
    }

    public float getRawVolume() {
        return (float) getVolume() / 300f;
    }

    public void setRadioMode() {
        if (isAntennaExist()) {
            if (IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) {
                setMonitorType(MonitorType.REMOTE_PLAYBACK_SELECT);
            } else {
                setMonitorType(MonitorType.RADIO_SELECT);
            }
        }
        update();
    }

    public boolean isRadio() {
        return isRadioStream() || isRadioRemote();
    }

    public boolean isRadioStream() {
        return monitorType == MonitorType.RADIO_SELECT || monitorType == MonitorType.RADIO;
    }

    public boolean isRadioRemote() {
        return monitorType == MonitorType.REMOTE_PLAYBACK || monitorType == MonitorType.REMOTE_PLAYBACK_SELECT;
    }


    public void setPower(boolean power) {
        access.setPower(power);
    }

    public boolean isChangeCassetteTape() {
        return changeCassetteTape;
    }

    private boolean isMusicCassetteTapeExist() {
        return isCassetteTapeExist() && CassetteTapeItem.getMusic(getCassetteTape()) != null;
    }

    private boolean isCassetteTapeExist() {
        return IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    public boolean isPlaying() {
        return playing;
    }


    public void setPlaying(boolean playing) {
        if (canPlay() || !playing) {
            this.playing = playing;
            update();
        }
    }


    public class_1799 getOldCassetteTape() {
        return oldCassetteTape;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
        update();
    }

    public MonitorType getMonitorType() {
        return monitorType;
    }

    public boolean isUseAntenna() {
        return isRadio();
    }

    public boolean isAntennaExist() {
        return IMPItemUtil.isAntenna(getAntenna());
    }

    @Nullable
    public IMusicRinger getRinger() {
        return access.getRinger();
    }

    public boolean cycleLidOpen(class_1937 level) {
        boolean flg = lidOpenProgress >= getLidOpenProgressMax();
        boolean flg2 = lidOpenProgress <= 0;
        if (!flg && !flg2) return false;
        if (flg) {
            startLidOpen(false, level);
        }
        if (flg2) {
            startLidOpen(true, level);
        }
        return true;
    }

    public void setContinuousType(ContinuousType continuousType) {
        this.continuousType = continuousType;
        update();
    }

    public ContinuousType getContinuousType() {
        return continuousType;
    }

    public void setSelectedMusic(Music selectedMusic) {
        this.selectedMusic = selectedMusic;
        update();
    }

    public Music getSelectedMusic() {
        return selectedMusic;
    }

    @Nullable
    public Music getCassetteTapeMusic() {
        if (IMPItemUtil.isCassetteTape(getCassetteTape())) return CassetteTapeItem.getMusic(getCassetteTape());
        return null;
    }

    public void startLidOpen(boolean open, class_1937 level) {
        setLidOpen(open);
        var pos = getPosition();
        level.method_8396(null, pos, isLidOpen() ? class_3417.field_14664 : class_3417.field_14541, class_3419.field_15245, 0.5F, 0.4F / (level.method_8409().method_43057() * 0.4F + 0.8F));
    }

    public boolean isLidOpen() {
        return lidOpen;
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        update();
    }

    public void setSelectedPlayList(@NotNull class_3222 player, UUID selectedPlayList) {
        if (selectedPlayList != null) {
            playerSelectPlaylists.put(player.method_7334().getId(), selectedPlayList);
        } else {
            playerSelectPlaylists.remove(player.method_7334().getId());
        }
        update();
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull class_1657 player) {
        return playerSelectPlaylists.get(player.method_7334().getId());
    }

    public class_1799 getCassetteTape() {
        return access.getCassetteTape();
    }

    public class_1799 getAntenna() {
        return access.getAntenna();
    }

    public int getLidOpenProgressMax() {
        return 10;
    }

    public int getHandleRaisedProgress() {
        return handleRaisedProgress;
    }

    public float getHandleRaisedProgress(float partialTicks) {
        return class_3532.method_16439(partialTicks, handleRaisedProgressOld, handleRaisedProgress);
    }

    public int getParabolicAntennaProgress() {
        return parabolicAntennaProgress;
    }

    public float getParabolicAntennaProgress(float partialTicks) {
        return class_3532.method_16439(partialTicks, parabolicAntennaProgressOld, parabolicAntennaProgress);
    }

    public int getLidOpenProgress() {
        return lidOpenProgress;
    }

    public float getLidOpenProgress(float partialTicks) {
        return class_3532.method_16439(partialTicks, lidOpenProgressOld, lidOpenProgress);
    }

    public boolean isLoop() {
        return loop;
    }

    public boolean isMute() {
        return mute;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        update();
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        update();
    }

    public void setVolume(int volume) {
        this.volume = volume;
        update();
    }

    public int getVolume() {
        return volume;
    }

    public int getAntennaProgress() {
        return antennaProgress;
    }

    public float getAntennaProgress(float partialTicks) {
        return class_3532.method_16439(partialTicks, antennaProgressOld, antennaProgress);
    }

    public boolean isHandleRaising() {
        return handleRaising;
    }

    public int getHandleRaisedMax() {
        return 10;
    }

    public boolean cycleRaisedHandle() {
        boolean flg = getHandleRaisedProgress() >= getHandleRaisedMax();
        boolean flg2 = getHandleRaisedProgress() <= 0;
        if (!flg && !flg2) return false;
        if (flg) {
            setHandleRaising(false);
        }
        if (flg2) {
            setHandleRaising(true);
        }
        return true;
    }

    public void setHandleRaising(boolean handleRaising) {
        this.handleRaising = handleRaising;
        update();
    }

    public void setHandleRaisedProgressOld(int handleRaisedProgressOld) {
        this.handleRaisedProgressOld = handleRaisedProgressOld;
    }

    public int getHandleRaisedProgressOld() {
        return handleRaisedProgressOld;
    }

    public void setHandleRaisedProgress(int handleRaisedProgress) {
        this.handleRaisedProgress = handleRaisedProgress;
    }

    public void setAntennaProgressOld(int antennaProgressOld) {
        this.antennaProgressOld = antennaProgressOld;
    }

    public boolean isPowered() {
        return access.isPowered();
    }

    public class_2338 getPosition() {
        return class_2338.method_49638(access.getPosition());
    }

    public void update() {
        access.dataUpdate(this);
    }

    public static enum MonitorType {
        OFF("off"), PLAYBACK("playback"), REMOTE_PLAYBACK("remote_playback"), REMOTE_PLAYBACK_SELECT("remote_playback_select"), RADIO("radio"), RADIO_SELECT("radio_select");
        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return MonitorType.OFF;
        }
    }

    public void setRadioStartFlg(boolean radioStartFlg) {
        this.radioStartFlg = radioStartFlg;
        update();
    }

    public static interface DataAccess {
        class_1799 getCassetteTape();

        class_1799 getAntenna();

        boolean isPowered();

        void setPower(boolean power);

        IMusicRinger getRinger();

        class_243 getPosition();

        void setCassetteTape(class_1799 stack);

        void dataUpdate(BoomboxData data);
    }

    public Buttons getButtons() {
        return new Buttons(isRadio(), isPlaying(), !isPlaying() && getMusicPosition() > 0, isLoop(), isMute(), !isMute() && volume >= 300);
    }

    public static record Buttons(boolean radio, boolean start, boolean pause, boolean loop, boolean volMute,
                                 boolean volMax) {
        public static final Buttons EMPTY = new Buttons(false, false, false, false, false, false);
    }

    public static enum ButtonType {
        NONE("none", n -> false), POWER("power", n -> false), RADIO("radio", n -> n.radio()), START("start", n -> n.start()), PAUSE("pause", n -> n.pause()), STOP("stop", n -> false), LOOP("loop", n -> n.loop()), VOL_DOWN("volDown", n -> false), VOL_UP("volUp", n -> false), VOL_MUTE("volMute", n -> n.volMute()), VOL_MAX("volMax", n -> n.volMax());
        private final String name;
        private final class_2561 component;
        private final Function<Buttons, Boolean> getter;

        private ButtonType(String name, Function<Buttons, Boolean> getter) {
            this.name = name;
            this.component = class_2561.method_43471("imp.button.boombox." + name);
            this.getter = getter;
        }

        public String getName() {
            return name;
        }

        public class_2561 getComponent() {
            return component;
        }

        public boolean getState(Buttons buttons) {
            return getter.apply(buttons);
        }

        public static ButtonType getByName(String name) {
            for (ButtonType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return NONE;
        }
    }

    public static enum ContinuousType {
        NONE("none"), ORDER("order"), RANDOM("random");
        private final String name;
        private final class_2561 component;

        private ContinuousType(String name) {
            this.name = name;
            this.component = class_2561.method_43471("imp.text.continuous." + name);
        }

        public class_2561 getComponent() {
            return component;
        }

        public String getName() {
            return name;
        }

        public static ContinuousType getByName(String name) {
            for (ContinuousType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return NONE;
        }
    }
}
