package dev.felnull.imp.client.gui.screen.monitor;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.music.MusicSyncManager;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class Monitor<T extends class_2586> extends class_362 implements IIMPSmartRender {
    protected final List<class_364> children = new ArrayList<>();
    public final List<class_339> renderables = new ArrayList<>();
    protected class_2561 title;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int leftPos;
    protected int topPos;

    public Monitor(class_2561 title, int x, int y, int width, int height) {
        this.title = title;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    protected int getStartX() {
        return leftPos + x;
    }

    protected int getStartY() {
        return topPos + y;
    }

    public void init(int leftPos, int topPos) {
        this.leftPos = leftPos;
        this.topPos = topPos;
    }

    public void depose() {
        renderables.clear();
        this.leftPos = 0;
        this.topPos = 0;
    }

    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {

    }

    public void renderAppearance(T blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {

    }

    protected <W extends class_339> W addRenderWidget(W widget) {
        renderables.add(widget);
        return widget;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }

    public void tick() {

    }

    public void onFilesDrop(List<Path> list) {

    }

    public PlayImageRenderer getPlayImageRenderer() {
        return PlayImageRenderer.getInstance();
    }

    public MusicSyncManager getSyncManager() {
        return MusicSyncManager.getInstance();
    }
}
