package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public abstract class ImportSelectBaseMMMonitor extends MusicManagerMonitor {
    private static final class_2561 IMPORT_YOUTUBE_PLAYLIST_TEXT = class_2561.method_43471("imp.button.importYoutubePlayList");

    public ImportSelectBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        addRenderWidget(new SmartButton(getStartX() + (width - 270) / 2, getStartY() + (height - 15) / 2, 270, 15, IMPORT_YOUTUBE_PLAYLIST_TEXT, n -> insMonitor(getImportYoutubeMonitor())));
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float) width;
        float onPxH = monitorHeight / (float) height;
        renderSmartButtonSprite(poseStack, multiBufferSource, (width - 270f) / 2f, (height - 15f) / 2f, OERenderUtils.MIN_BREADTH * 2, 270, 15, i, j, onPxW, onPxH, monitorHeight, IMPORT_YOUTUBE_PLAYLIST_TEXT, true);
    }

    abstract public @NotNull MusicManagerBlockEntity.MonitorType getImportYoutubeMonitor();
}
