package dev.felnull.imp.client.handler;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IMPConfig;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicSyncManager;
import dev.felnull.imp.client.music.media.NetEaseCloudMusicManager;
import dev.felnull.imp.client.renderer.item.IMPItemRenderers;
import dev.felnull.imp.client.renderer.item.hand.BoomboxHandRenderer;
import dev.felnull.imp.entity.IRingerPartyParrot;
import dev.felnull.imp.integration.PatchouliIntegration;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.IconButton;
import dev.felnull.otyacraftengine.event.MoreEntityEvent;
import dev.felnull.otyacraftengine.item.location.HandItemLocation;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_443;
import net.minecraft.class_572;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2561 CONFIG_BUTTON = class_2561.method_43471("imp.button.config");
    private static final TextureRegion CONFIG_BUTTON_REGION = TextureRegion.relative(MusicManagerMonitor.WIDGETS_TEXTURE, 36, 58, 14, 5);
    private static double LAST_MUSIC_VOLUME = IamMusicPlayer.getConfig().volume;

    public static void init() {
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientHandler::onClientLevelLoad);
        ClientEvent.CHANGE_HAND_HEIGHT.register(ClientHandler::changeHandHeight);
        AutoConfig.getConfigHolder(IMPConfig.class).registerSaveListener(ClientHandler::onConfigSave);
        ClientEvent.POSE_HUMANOID_ARM.register(ClientHandler::onPoseHumanoidArm);
        ClientEvent.INTEGRATED_SERVER_PAUSE.register(ClientHandler::onPauseChange);
        MoreEntityEvent.LIVING_ENTITY_TICK.register(ClientHandler::onLivingEntityTick);
        ClientTickEvent.CLIENT_POST.register(ClientHandler::ontClientTick);
        ClientEvent.HAND_ATTACK.register(ClientHandler::onHandAttack);
        ClientGuiEvent.SET_SCREEN.register(ClientHandler::onModifyScreen);
        ClientGuiEvent.INIT_POST.register(ClientHandler::onScreenInit);

    }

    private static void onScreenInit(class_437 screen, ScreenAccess screenAccess) {
        if (screen instanceof class_443) {
            LAST_MUSIC_VOLUME = IamMusicPlayer.getConfig().volume;

            screenAccess.addRenderableWidget(new IconButton(screen.field_22789 - 27, screen.field_22790 - 27, 20, 20, CONFIG_BUTTON, (button) -> mc.method_1507(AutoConfig.getConfigScreen(IMPConfig.class, screen).get()), CONFIG_BUTTON_REGION));
        }
    }

    private static CompoundEventResult<class_437> onModifyScreen(class_437 screen) {
        if (mc.field_1755 instanceof class_443 && LAST_MUSIC_VOLUME != IamMusicPlayer.getConfig().volume)
            AutoConfig.getConfigHolder(IMPConfig.class).save();
        return CompoundEventResult.pass();
    }

    private static EventResult onHandAttack(@NotNull class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BoomboxItem && BoomboxItem.isPowered(itemStack)) {
            if (mc.field_1724.method_18276()) {
                var bu = BoomboxItem.getRingerUUID(itemStack);
                if (bu != null)
                    NetworkManager.sendToServer(IMPPackets.HAND_LID_CYCLE, new IMPPackets.LidCycleMessage(bu, new HandItemLocation(class_1268.field_5808)).toFBB());
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult onLivingEntityTick(@NotNull class_1309 livingEntity) {
        if (!livingEntity.field_6002.method_8608()) return EventResult.pass();

        if (livingEntity instanceof IRingerPartyParrot ringerPartyParrot) {
            var mm = MusicEngine.getInstance();
            var id = ringerPartyParrot.getRingerUUID();
            if (id == null || !mm.isPlaying(id))
                ringerPartyParrot.setRingerUUID(null);
        }

        return EventResult.pass();
    }

    private static void onPauseChange(boolean paused) {
        var rm = MusicRingManager.getInstance();
        var nmm = MusicEngine.getInstance();
        if (paused) {
            rm.pause();
            nmm.pause();
        } else {
            rm.resume();
            nmm.resume();
        }
    }

    private static class_1269 onConfigSave(ConfigHolder<IMPConfig> configHolder, IMPConfig impConfig) {
        MusicEngine.getInstance().destroy();
        NetEaseCloudMusicManager.getInstance().reload();
        return class_1269.field_5811;
    }


    private static void onClientLevelLoad(class_638 clientLevel) {
        MusicSyncManager.getInstance().reset();
    }

    private static EventResult changeHandHeight(class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        if (oldStack.method_7909() instanceof BoomboxItem && newStack.method_7909() instanceof BoomboxItem && BoomboxItem.matches(oldStack, newStack))
            return EventResult.interruptFalse();
        return EventResult.pass();
    }

    private static EventResult onPoseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity) {
        var item = livingEntity.method_5998(hand);
        if (item.method_31574(IMPBlocks.BOOMBOX.get().method_8389()) && BoomboxItem.getTransferProgress(item) >= 1f) {
            BoomboxHandRenderer.pose(arm, model, item);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void ontClientTick(class_310 instance) {
        if (PatchouliIntegration.INSTANCE.isEnable())
            IMPItemRenderers.manualItemRenderer.tick();
    }
}
