package dev.felnull.imp.impl;

import dev.felnull.imp.api.IamMusicPlayerAPI;
import dev.felnull.imp.api.MusicRingerAccess;
import dev.felnull.imp.server.music.ringer.MusicRing;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import org.jetbrains.annotations.Unmodifiable;

import java.util.Collection;
import net.minecraft.class_3218;

public class IamMusicPlayerAPIImpl implements IamMusicPlayerAPI {
    public static final IamMusicPlayerAPI INSTANCE = new IamMusicPlayerAPIImpl();

    @Unmodifiable
    @Override
    public Collection<MusicRingerAccess> getRingers() {
        return MusicRingManager.getInstance().getMusicRingers().values().stream().flatMap(n -> n.getRingers().values().stream()).map(n -> (MusicRingerAccess) n).toList();
    }

    @Unmodifiable
    @Override
    public Collection<MusicRingerAccess> getRingers(class_3218 level) {
        var mr = MusicRingManager.getInstance().getMusicRingers().get(level);
        return mr.getRingers().values().stream().map(n -> (MusicRingerAccess) n).toList();
    }
}
