package dev.felnull.imp.item;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.integration.PatchouliIntegration;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1814;
import net.minecraft.class_7924;

public class IMPItems {
    private static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create(IamMusicPlayer.MODID, class_7924.field_41197);
    public static final RegistrySupplier<class_1792> RADIO_ANTENNA = register("radio_antenna", () -> new RadioAntennaItem(new class_1792.class_1793().arch$tab(IMPCreativeModeTab.MOD_TAB).method_7889(1)));
    public static final RegistrySupplier<class_1792> PARABOLIC_ANTENNA = register("parabolic_antenna", () -> new ParabolicAntennaItem(new class_1792.class_1793().arch$tab(IMPCreativeModeTab.MOD_TAB).method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<class_1792> CASSETTE_TAPE = register("cassette_tape", () -> new CassetteTapeItem(new class_1792.class_1793().arch$tab(IMPCreativeModeTab.MOD_TAB).method_7889(1), CassetteTapeItem.BaseType.NORMAL));
    public static final RegistrySupplier<class_1792> CASSETTE_TAPE_GLASS = register("cassette_tape_glass", () -> new CassetteTapeItem(new class_1792.class_1793().arch$tab(IMPCreativeModeTab.MOD_TAB).method_7889(1), CassetteTapeItem.BaseType.GLASS));
    public static final RegistrySupplier<class_1792> MANUAL = register("manual", () -> {
        var pr = new class_1792.class_1793().method_7889(1);
        if (PatchouliIntegration.INSTANCE.isEnableElement())
            pr.arch$tab(IMPCreativeModeTab.MOD_TAB);
        return new ManualItem(pr);
    });

    //  public static final RegistrySupplier<Item> SOUND_TEST = register("sound_test", () -> new SoundTestItem(new Item.Properties().tab(IMPCreativeModeTab.MOD_TAB)));


    private static RegistrySupplier<class_1792> register(String name) {
        return register(name, () -> new class_1792(new class_1792.class_1793().arch$tab(IMPCreativeModeTab.MOD_TAB)));
    }

    private static RegistrySupplier<class_1792> register(String name, Supplier<class_1792> item) {
        return ITEMS.register(name, item);
    }

    public static void init() {
        ITEMS.register();
    }
}
