package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.api.MusicRingerAccess;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public interface IMusicRinger extends MusicRingerAccess {
    class_2561 getRingerName();

    class_3218 getRingerLevel();

    UUID getRingerUUID();

    boolean exists();

    boolean isRingerPlaying();

    void setRingerPlaying(boolean playing);

    @Nullable
    MusicSource getRingerMusicSource();

    boolean isRingerLoop();

    long getRingerPosition();

    void setRingerPosition(long position);

    MusicTrackerEntry getRingerTracker();

    @NotNull
    class_243 getRingerSpatialPosition();

    float getRingerVolume();

    float getRingerRange();

    boolean isRingerStream();

    default boolean isRingerWait() {
        return getMusicRing().isWaitRinger(getRingerUUID());
    }

    default MusicRing getMusicRing() {
        return MusicRingManager.getInstance().getMusicRing(getRingerLevel());
    }

    default boolean alreadyAdded() {
        return getMusicRing().hasRinger(getRingerUUID());
    }

    default void ringerTick() {
        if (!alreadyAdded())
            addRingerInRingManager();
    }

    default void addRingerInRingManager() {
        getMusicRing().addRinger(this);
    }

    default void ringerRestart() {
        getMusicRing().restart(getRingerUUID());
    }

    default void ringerEnd() {
    }

    boolean isRingerMute();

    default boolean isRingerRemote() {
        return false;
    }

    @Nullable
    default String getRingerMusicAuthor() {
        return null;
    }

    @NotNull
    default class_1799 getRingerAntenna() {
        return class_1799.field_8037;
    }

    @Override
    default class_2561 getName() {
        return getRingerName();
    }

    @Override
    default class_243 getSpatialPosition() {
        return getRingerSpatialPosition();
    }

    @Override
    default boolean isPlaying() {
        return isRingerPlaying();
    }

    @Override
    default class_3218 getServerLevel() {
        return getRingerLevel();
    }
}
