/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.components.BoomboxButton;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.gui.screen.OEItemBEContainerBasedScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.inventory.OEItemBEBaseMenu;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxScreen
extends OEItemBEContainerBasedScreen<BoomboxMenu> {
    public static final class_2960 BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/boombox_base.png");
    public static final class_2960 EMPTY_CASSETTE_TAPE_SLOT = new class_2960("iammusicplayer", "textures/gui/container/slot/cassette_tape_slot.png");
    public static final class_2960 EMPTY_ANTENNA_SLOT = new class_2960("iammusicplayer", "textures/gui/container/slot/antenna_slot.png");
    private final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<BoomboxData.MonitorType, BoomboxMonitor>();
    protected BoomboxMonitor monitor;
    public long lastNoAntenna;

    public BoomboxScreen(BoomboxMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((OEItemBEBaseMenu)abstractContainerMenu, inventory, component);
        this.field_2792 = 214;
        this.field_2779 = 175;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5, this.field_2800 + 17, BoomboxData.ButtonType.POWER, n -> this.insPressButton(BoomboxData.ButtonType.POWER), this::getButtons, this::isPowered));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 19, this.field_2800 + 17, BoomboxData.ButtonType.RADIO, n -> {
            if (!this.getAntenna().method_7960() && IMPItemUtil.isAntenna(this.getAntenna())) {
                this.insPressButton(BoomboxData.ButtonType.RADIO);
            } else {
                this.lastNoAntenna = System.currentTimeMillis();
            }
        }, this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 38, this.field_2800 + 17, BoomboxData.ButtonType.START, n -> this.insPressButton(BoomboxData.ButtonType.START), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 57, this.field_2800 + 17, BoomboxData.ButtonType.PAUSE, n -> this.insPressButton(BoomboxData.ButtonType.PAUSE), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 76, this.field_2800 + 17, BoomboxData.ButtonType.STOP, n -> this.insPressButton(BoomboxData.ButtonType.STOP), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 95, this.field_2800 + 17, BoomboxData.ButtonType.LOOP, n -> this.insPressButton(BoomboxData.ButtonType.LOOP), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 114 + 14, this.field_2800 + 17, BoomboxData.ButtonType.VOL_DOWN, n -> this.insPressButton(BoomboxData.ButtonType.VOL_DOWN), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 133 + 14, this.field_2800 + 17, BoomboxData.ButtonType.VOL_UP, n -> this.insPressButton(BoomboxData.ButtonType.VOL_UP), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 152 + 14, this.field_2800 + 17, BoomboxData.ButtonType.VOL_MUTE, n -> this.insPressButton(BoomboxData.ButtonType.VOL_MUTE), this::getButtons));
        this.method_37063((class_364)new BoomboxButton(this.field_2776 + 5 + 171 + 14, this.field_2800 + 17, BoomboxData.ButtonType.VOL_MAX, n -> this.insPressButton(BoomboxData.ButtonType.VOL_MAX), this::getButtons));
        this.changeScreenMonitor(this.getRawMonitorType());
    }

    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
    }

    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
        super.method_2389(poseStack, f, i, j);
        if (this.getCassetteTape().method_7960()) {
            OERenderUtils.drawTexture((class_2960)EMPTY_CASSETTE_TAPE_SLOT, (class_4587)poseStack, (float)(this.field_2776 + 183), (float)(this.field_2800 + 98), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f);
        }
        if (this.getAntenna().method_7960()) {
            OERenderUtils.drawTexture((class_2960)EMPTY_ANTENNA_SLOT, (class_4587)poseStack, (float)(this.field_2776 + 183), (float)(this.field_2800 + 124), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f);
        }
        if (this.monitor != null) {
            this.monitor.render(poseStack, f, i, j);
        }
    }

    protected void method_37432() {
        super.method_37432();
        if (this.monitor != null) {
            if (this.getRawMonitorType() != this.monitor.getType()) {
                this.changeScreenMonitor(this.getRawMonitorType());
            }
            this.monitor.tick();
        }
    }

    public void insSelectedPlayList(@Nullable UUID uuid) {
        class_2487 tag = new class_2487();
        if (uuid != null) {
            tag.method_25927("pl", uuid);
        }
        this.instruction("set_selected_play_list", tag);
    }

    public void insRadioUrl(String url) {
        class_2487 tag = new class_2487();
        tag.method_10582("url", url);
        this.instruction("set_radio_url", tag);
    }

    public void insSelectedMusic(@Nullable UUID musicId) {
        class_2487 tag = new class_2487();
        if (musicId != null) {
            tag.method_25927("m", musicId);
        }
        this.instruction("set_selected_music", tag);
    }

    public boolean isMute() {
        return this.getBoomBoxData().isMute();
    }

    public boolean isPlaying() {
        return this.getBoomBoxData().isPlaying();
    }

    public int getVolume() {
        return this.getBoomBoxData().getVolume();
    }

    public long getMusicPosition() {
        return this.getBoomBoxData().getMusicPosition();
    }

    private boolean isPowered() {
        return this.getBoomBoxData().isPowered();
    }

    public boolean isLoop() {
        return this.getBoomBoxData().isLoop();
    }

    public BoomboxData getBoomBoxData() {
        class_2586 class_25862;
        if (this.isBlock() && (class_25862 = this.getBlockEntity()) instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)class_25862;
            return boomboxBlockEntity.getBoomboxData();
        }
        return BoomboxItem.getData(this.getItem());
    }

    public void insMonitor(BoomboxData.MonitorType monitorType) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", monitorType.getName());
        this.instruction("set_monitor", tag);
    }

    public boolean isMusicLoading() {
        return this.getBoomBoxData().isLoadingMusic();
    }

    public class_1799 getCassetteTape() {
        return (class_1799)((BoomboxMenu)this.method_17577()).method_7602().get(0);
    }

    public class_1799 getAntenna() {
        return (class_1799)((BoomboxMenu)this.method_17577()).method_7602().get(1);
    }

    public void insVolume(int volume) {
        class_2487 tag = new class_2487();
        tag.method_10569("volume", volume);
        this.instruction("set_volume", tag);
    }

    public void insPositionAndRestart(long position) {
        class_2487 tag = new class_2487();
        tag.method_10544("position", position);
        this.instruction("restat_and_set_position", tag);
    }

    public void insContinuousType(@NotNull BoomboxData.ContinuousType continuousType) {
        class_2487 tag = new class_2487();
        tag.method_10582("type", continuousType.getName());
        this.instruction("set_continuous_type", tag);
    }

    public void insLoop(boolean loop) {
        class_2487 tag = new class_2487();
        tag.method_10556("loop", loop);
        this.instruction("set_loop", tag);
    }

    public void insPause() {
        this.instruction("set_pause", new class_2487());
    }

    public void insPlaying(boolean playing) {
        class_2487 tag = new class_2487();
        tag.method_10556("playing", playing);
        this.instruction("set_playing", tag);
    }

    public void insRadioSource(MusicSource source) {
        class_2487 tag = new class_2487();
        tag.method_10566("source", (class_2520)source.createSavedTag());
        this.instruction("set_radio_source", tag);
    }

    public void insRadioImage(ImageInfo imageInfo) {
        class_2487 tag = new class_2487();
        tag.method_10566("image", (class_2520)imageInfo.createSavedTag());
        this.instruction("set_radio_image", tag);
    }

    public void insRadioName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("name", name);
        this.instruction("set_radio_name", tag);
    }

    public void insRadioAuthor(String author) {
        class_2487 tag = new class_2487();
        tag.method_10582("author", author);
        this.instruction("set_radio_author", tag);
    }

    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    private BoomboxData.Buttons getButtons() {
        return this.getBoomBoxData().getButtons();
    }

    private void insPressButton(BoomboxData.ButtonType type) {
        class_2487 tag = new class_2487();
        tag.method_10582("Type", type.getName());
        this.instruction("buttons_press", tag);
    }

    private void changeScreenMonitor(BoomboxData.MonitorType type) {
        if (this.monitor != null) {
            this.monitor.renderables.forEach(x$0 -> this.method_37066((class_364)x$0));
            this.monitor.depose();
        }
        if (!this.monitors.containsKey((Object)type)) {
            this.monitors.put(type, BoomboxMonitor.createdBoomBoxMonitor(type, this));
        }
        this.monitor = this.monitors.get((Object)type);
        this.monitor.init(this.field_2776, this.field_2800);
        this.monitor.renderables.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    private BoomboxData.MonitorType getRawMonitorType() {
        return this.getBoomBoxData().getMonitorType();
    }

    public void method_25419() {
        super.method_25419();
        if (this.monitor != null) {
            this.monitor.depose();
        }
    }

    public void method_29638(List<Path> list) {
        if (this.monitor != null) {
            this.monitor.onFilesDrop(list);
        }
    }
}

