/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SearchMusicsFixedListWidget;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class SearchMusicMMMonitor
extends MusicManagerMonitor {
    private static final class_2960 SEARCH_MUSIC_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/search_music.png");
    private static final class_2561 SEARCHING_TEXT = class_2561.method_43471((String)"imp.text.searching");
    private final List<MusicMediaResult> searchMusics = new ArrayList<MusicMediaResult>();
    private SearchMusicsFixedListWidget searchMusicsFixedButtonsList;
    private class_342 searchNameEditBox;
    private SearchThread searchThread;

    public SearchMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.searchMusicsFixedButtonsList = this.addRenderWidget(new SearchMusicsFixedListWidget(this.getStartX() + 2, this.getStartY() + 25, 366, 172, (class_2561)class_2561.method_43471((String)"imp.fixedList.searchMusic"), 4, this.searchMusics, (FixedListWidget.PressEntry<MusicMediaResult>)((FixedListWidget.PressEntry)(widget, item) -> {
            this.setMusicSourceName(item.source().getIdentifier());
            this.getScreen().lastSearch = true;
            this.insMonitor(MusicManagerBlockEntity.MonitorType.ADD_MUSIC);
        }), this.searchMusicsFixedButtonsList));
        this.searchNameEditBox = new class_342(IIMPSmartRender.mc.field_1772, this.getStartX() + 2, this.getStartY() + 11, 367, 12, (class_2561)class_2561.method_43471((String)"imp.editBox.musicSearchName"));
        this.searchNameEditBox.method_1880(300);
        this.searchNameEditBox.method_1852(this.getMusicSearchName());
        this.searchNameEditBox.method_1863(this::setMusicSearchName);
        this.addRenderWidget(this.searchNameEditBox);
        this.startMusicSearch(this.getMusicSearchName());
    }

    @Override
    public void depose() {
        super.depose();
        this.stopMusicSearch();
        this.searchMusics.clear();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((class_2960)SEARCH_MUSIC_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.searchMusics.isEmpty() && !this.getMusicSearchName().isEmpty() && this.searchThread != null && this.searchThread.isAlive()) {
            this.drawSmartText(poseStack, SEARCHING_TEXT, this.getStartX() + 3, this.getStartY() + 27);
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((class_2960)SEARCH_MUSIC_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 2.0f, 11.0f, 0.003f, 367.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getMusicSearchName(blockEntity));
        this.renderScrollbarSprite(poseStack, multiBufferSource, 359.0f, 25.0f, 0.003f, 172.0f, i, j, onPxW, onPxH, monitorHeight, 0, 6);
    }

    private void startMusicSearch(String name) {
        this.stopMusicSearch();
        this.searchThread = new SearchThread(name);
        this.searchThread.start();
    }

    private void stopMusicSearch() {
        if (this.searchThread != null) {
            this.searchThread.stopped();
            this.searchThread = null;
        }
    }

    public String getMusicSearchName() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getMusicSearchName(blockEntity);
        }
        return "";
    }

    public String getMusicSearchName(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicSearchName((class_1657)SearchMusicMMMonitor.mc.field_1724);
    }

    private void setMusicSearchName(String name) {
        if (!this.getMusicSearchName().equals(name)) {
            this.startMusicSearch(name);
        }
        this.getScreen().insMusicSearchName(name);
    }

    private void setMusicSourceName(String name) {
        this.getScreen().insMusicSourceName(name);
    }

    public MusicMedia getRawMusicLoaderType() {
        return IMPMusicMedias.getAllMedia().get(this.getMusicLoaderType());
    }

    public String getMusicLoaderType() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getMusicLoaderType(blockEntity);
        }
        return "auto";
    }

    public String getMusicLoaderType(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicLoaderType((class_1657)SearchMusicMMMonitor.mc.field_1724).isEmpty() ? "auto" : blockEntity.getMusicLoaderType((class_1657)SearchMusicMMMonitor.mc.field_1724);
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_MUSIC;
    }

    private class SearchThread
    extends FlagThread {
        private final String name;

        public SearchThread(String name) {
            this.name = name;
        }

        public void run() {
            if (this.isStopped()) {
                return;
            }
            MusicMedia lt = SearchMusicMMMonitor.this.getRawMusicLoaderType();
            if (lt == null || !lt.isSearchable()) {
                return;
            }
            if (this.isStopped()) {
                return;
            }
            List<MusicMediaResult> slst = lt.search(this.name);
            if (this.isStopped()) {
                return;
            }
            this.setSearchMusics(slst);
        }

        private synchronized void setSearchMusics(List<MusicMediaResult> musics) {
            if (musics != null) {
                SearchMusicMMMonitor.this.searchMusics.clear();
                SearchMusicMMMonitor.this.searchMusics.addAll(musics);
            }
        }
    }
}

