/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer;

import dev.felnull.imp.api.client.IamMusicPlayerClientAPI;
import dev.felnull.imp.api.client.MusicEngineAccess;
import dev.felnull.imp.api.client.MusicPlayerAccess;
import dev.felnull.imp.api.client.MusicSpeakerAccess;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec3f;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNForUtil;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.lwjgl.openal.AL11;

public class DebugSpeakerRangeRenderer {
    public static void render(class_4587 poseStack, class_4597 multiBufferSource, double camX, double camY, double camZ) {
        MusicEngineAccess me = IamMusicPlayerClientAPI.getInstance().getMusicEngine();
        for (MusicPlayerAccess player : me.getMusicPlayers().values()) {
            for (MusicSpeakerAccess speaker : player.getSpeakers().values()) {
                DebugSpeakerRangeRenderer.renderSpeaker(poseStack, multiBufferSource, camX, camY, camZ, player, speaker);
            }
        }
    }

    private static void renderSpeaker(class_4587 poseStack, class_4597 multiBufferSource, double camX, double camY, double camZ, MusicPlayerAccess playerAccess, MusicSpeakerAccess speaker) {
        class_4588 lineVC = multiBufferSource.getBuffer(class_1921.method_23594());
        class_243 pos = speaker.getInfo().getPosition();
        float x = (float)(pos.method_10216() - camX);
        float y = (float)(pos.method_10214() - camY);
        float z = (float)(pos.method_10215() - camZ);
        class_243 listener = DebugSpeakerRangeRenderer.getListenerPos();
        double distance = listener.method_1022(speaker.getInfo().getPosition());
        boolean inRange = distance <= (double)speaker.getInfo().getRange();
        DebugSpeakerRangeRenderer.renderLineBox(poseStack, lineVC, x, y, z, -0.05f, -0.05f, -0.05f, 0.05f, 0.05f, 0.05f, -1);
        float range = speaker.getInfo().getRange();
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, -range, 0.0f, 0.0f, range, 0.0f, 0.0f, -16776961);
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, 0.0f, -range, 0.0f, 0.0f, range, 0.0f, -16776961);
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, 0.0f, 0.0f, -range, 0.0f, 0.0f, range, -16776961);
        DebugSpeakerRangeRenderer.renderLineSphere(poseStack, lineVC, x, y, z, range, class_3532.method_15340((int)((int)range), (int)3, (int)50), !playerAccess.isLoaded() ? -256 : (inRange ? -16711936 : -65536));
    }

    private static void renderLineSphere(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float range, int corner, int color) {
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
    }

    private static void renderLineQuarterSphereX(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float rangeX, float rangeY, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float px = rangeX;
        float py = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rx = (float)((double)rangeX * Math.cos(dr));
            float ry = (float)((double)rangeY * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, py, 0.0f, rx, ry, 0.0f, color);
            px = rx;
            py = ry;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, py, 0.0f, 0.0f, rangeY, 0.0f, color);
    }

    private static void renderLineQuarterSphereY(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float rangeX, float rangeZ, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float px = rangeX;
        float pz = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rx = (float)((double)rangeX * Math.cos(dr));
            float rz = (float)((double)rangeZ * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, 0.0f, pz, rx, 0.0f, rz, color);
            px = rx;
            pz = rz;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, 0.0f, pz, 0.0f, 0.0f, rangeZ, color);
    }

    private static void renderLineQuarterSphereZ(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float rangeZ, float rangeY, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float pz = rangeZ;
        float py = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rz = (float)((double)rangeZ * Math.cos(dr));
            float ry = (float)((double)rangeY * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, 0.0f, py, pz, 0.0f, ry, rz, color);
            pz = rz;
            py = ry;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, 0.0f, py, pz, 0.0f, rangeY, 0.0f, color);
    }

    private static void renderLineBox(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float stX, float stY, float stZ, float enX, float enY, float enZ, int color) {
        FNForUtil.forBoxEdge(stX, stY, stZ, enX, enY, enZ, ret -> {
            FNVec3f st = (FNVec3f)ret.getLeft();
            FNVec3f en = (FNVec3f)ret.getRight();
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, st.getX(), st.getY(), st.getZ(), en.getX(), en.getY(), en.getZ(), color);
        });
    }

    private static void renderLine(class_4587 poseStack, class_4588 vertexConsumer, float x, float y, float z, float stX, float stY, float stZ, float enX, float enY, float enZ, int color) {
        float nx = enX - stX;
        float ny = enY - stY;
        float nz = enZ - stZ;
        float t = class_3532.method_15355((float)(nx * nx + ny * ny + nz * nz));
        nx /= t;
        ny /= t;
        nz /= t;
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float a = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        class_4587.class_4665 pose = poseStack.method_23760();
        vertexConsumer.method_22918(pose.method_23761(), stX + x, stY + y, stZ + z).method_22915(r, g, b, a).method_23763(pose.method_23762(), nx, ny, nz).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), enX + x, enY + y, enZ + z).method_22915(r, g, b, a).method_23763(pose.method_23762(), nx, ny, nz).method_1344();
    }

    private static class_243 getListenerPos() {
        float[] x = new float[1];
        float[] y = new float[1];
        float[] z = new float[1];
        AL11.alGetListener3f((int)4100, (float[])x, (float[])y, (float[])z);
        return new class_243((double)x[0], (double)y[0], (double)z[0]);
    }
}

