/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePlaylistLoader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.Units;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.entity.StringEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultYoutubePlaylistLoader
implements YoutubePlaylistLoader {
    private volatile int playlistPageCount = 6;

    @Override
    public void setPlaylistPageCount(int playlistPageCount) {
        this.playlistPageCount = playlistPageCount;
    }

    @Override
    public AudioPlaylist load(HttpInterface httpInterface, String playlistId, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        AudioPlaylist audioPlaylist;
        block8: {
            HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/browse");
            YoutubeClientConfig clientConfig = YoutubeClientConfig.ANDROID.copy().withRootField("browseId", "VL" + playlistId).setAttribute(httpInterface);
            StringEntity payload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
            post.setEntity(payload);
            CloseableHttpResponse response = httpInterface.execute(post);
            try {
                HttpClientTools.assertSuccessWithContent(response, "playlist response");
                HttpClientTools.assertJsonContentType(response);
                JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
                audioPlaylist = this.buildPlaylist(httpInterface, json, selectedVideoId, trackFactory);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return audioPlaylist;
    }

    private AudioPlaylist buildPlaylist(HttpInterface httpInterface, JsonBrowser json, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        String errorAlertMessage = this.findErrorAlert(json);
        if (errorAlertMessage != null) {
            throw new FriendlyException(errorAlertMessage, FriendlyException.Severity.COMMON, null);
        }
        String playlistName = json.get("header").get("playlistHeaderRenderer").get("title").get("runs").index(0).get("text").text();
        JsonBrowser playlistVideoList = json.get("contents").get("singleColumnBrowseResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("playlistVideoListRenderer");
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        String continuationsToken = this.extractPlaylistTracks(playlistVideoList, tracks, trackFactory);
        int loadCount = 0;
        int pageCount = this.playlistPageCount;
        while (continuationsToken != null && ++loadCount < pageCount) {
            HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/browse");
            YoutubeClientConfig clientConfig = YoutubeClientConfig.ANDROID.copy().withRootField("continuation", continuationsToken).setAttribute(httpInterface);
            StringEntity payload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
            post.setEntity(payload);
            CloseableHttpResponse response = httpInterface.execute(post);
            try {
                HttpClientTools.assertSuccessWithContent(response, "playlist response");
                JsonBrowser continuationJson = JsonBrowser.parse(response.getEntity().getContent());
                JsonBrowser playlistVideoListPage = continuationJson.get("continuationContents").get("playlistVideoListContinuation");
                continuationsToken = this.extractPlaylistTracks(playlistVideoListPage, tracks, trackFactory);
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        return new BasicAudioPlaylist(playlistName, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    private String findErrorAlert(JsonBrowser jsonResponse) {
        JsonBrowser alerts = jsonResponse.get("alerts");
        if (!alerts.isNull()) {
            for (JsonBrowser alert : alerts.values()) {
                JsonBrowser alertInner = alert.get("alertRenderer");
                String type = alertInner.get("type").text();
                if (!"ERROR".equals(type)) continue;
                JsonBrowser textObject = alertInner.get("text");
                String text = !textObject.get("simpleText").isNull() ? textObject.get("simpleText").text() : textObject.get("runs").values().stream().map(run -> run.get("text").text()).collect(Collectors.joining());
                return text;
            }
        }
        return null;
    }

    private AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }

    private String extractPlaylistTracks(JsonBrowser playlistVideoList, List<AudioTrack> tracks, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        JsonBrowser contents = playlistVideoList.get("contents");
        if (contents.isNull()) {
            return null;
        }
        List<JsonBrowser> playlistTrackEntries = contents.values();
        for (JsonBrowser track : playlistTrackEntries) {
            JsonBrowser item = track.get("playlistVideoRenderer");
            JsonBrowser shortBylineText = item.get("shortBylineText");
            if (item.get("isPlayable").isNull() || shortBylineText.isNull()) continue;
            String videoId = item.get("videoId").text();
            JsonBrowser titleField = item.get("title");
            String title = titleField.get("simpleText").textOrDefault(titleField.get("runs").index(0).get("text").text());
            String author = shortBylineText.get("runs").index(0).get("text").textOrDefault("Unknown artist");
            JsonBrowser lengthSeconds = item.get("lengthSeconds");
            long duration = Units.secondsToMillis(lengthSeconds.asLong(Long.MAX_VALUE));
            AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, ThumbnailTools.getYouTubeThumbnail(item, videoId), null);
            tracks.add(trackFactory.apply(info));
        }
        JsonBrowser continuations = playlistVideoList.get("continuations").index(0).get("nextContinuationData");
        if (!continuations.isNull()) {
            String continuationsToken = continuations.get("continuation").text();
            return continuationsToken;
        }
        return null;
    }
}

