package dev.felnull.imp.advancements;

import com.google.gson.JsonObject;
import dev.felnull.imp.IamMusicPlayer;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class ListenToMusicTrigger extends class_4558<ListenToMusicTrigger.TriggerInstance> {
    private static final class_2960 ID = new class_2960(IamMusicPlayer.MODID, "listen_to_music");

    @Override
    protected TriggerInstance method_27854(JsonObject jo, class_2048.class_5258 composite, class_5257 deserializationContext) {
        boolean radio = jo.has("radio") && jo.get("radio").getAsBoolean();
        boolean remote = jo.has("remote") && jo.get("remote").getAsBoolean();
        boolean kamesuta = jo.has("kamesuta") && jo.get("kamesuta").getAsBoolean();
        return new TriggerInstance(composite, radio, remote, kamesuta);
    }

    public void trigger(class_3222 serverPlayer, boolean radio, boolean remote, boolean kamesuta) {
        this.method_22510(serverPlayer, (triggerInstance) -> triggerInstance.matches(radio, remote, kamesuta));
    }

    @Override
    public class_2960 method_794() {
        return ID;
    }

    public static class TriggerInstance extends class_195 {
        private final boolean radio;
        private final boolean remote;
        private final boolean kamesuta;

        public TriggerInstance(class_2048.class_5258 composite, boolean radio, boolean remote, boolean kamesuta) {
            super(ID, composite);
            this.radio = radio;
            this.remote = remote;
            this.kamesuta = kamesuta;
        }

        public boolean matches(boolean radio, boolean remote, boolean kamesuta) {
            if (this.radio && !radio)
                return false;
            if (this.remote && !remote)
                return false;
            return !this.kamesuta || kamesuta;
        }

        @Override
        public JsonObject method_807(class_5267 serializationContext) {
            JsonObject jo = super.method_807(serializationContext);
            jo.addProperty("radio", this.radio);
            jo.addProperty("remote", this.remote);
            jo.addProperty("kamesuta", this.kamesuta);
            return jo;
        }

        public static TriggerInstance listen(boolean radio, boolean remote, boolean kamesuta) {
            return new TriggerInstance(class_2048.class_5258.field_24388, radio, remote, kamesuta);
        }
    }
}
