package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListMMMonitor;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class YoutubePlayListMusicsFixedListWidget extends IMPBaseFixedListWidget<ImportYoutubePlayListMMMonitor.YoutubePlayListEntry> {
    public YoutubePlayListMusicsFixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<ImportYoutubePlayListMMMonitor.YoutubePlayListEntry> entryList, @Nullable FixedListWidget<ImportYoutubePlayListMMMonitor.YoutubePlayListEntry> old) {
        super(x, y, width, height, message, entryShowCount, entryList, n -> class_2561.method_43470(n.name()), null, false, old);
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, ImportYoutubePlayListMMMonitor.YoutubePlayListEntry item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        drawSmartButtonBox(poseStack, bX, bY, getIndividualWidth(), getIndividualHeight(), this.getYImage(this.isEntryHovered(bnum)));
        var img = item.imageInfo();
        float sx = 1;

        if (!img.isEmpty()) {
            sx += getIndividualHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, bX + 1, bY + 1, getIndividualHeight() - 2, false);
        }
        drawSmartFixedWidthText(poseStack, class_2561.method_43470(item.name()), bX + sx, bY + 2, getIndividualWidth() - sx - 2);
        drawSmartFixedWidthText(poseStack, class_2561.method_43470(item.artist()), bX + sx, bY + 12, getIndividualWidth() - sx - 2);
    }
}
