package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.components.BoomboxButton;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.gui.screen.OEItemBEContainerBasedScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class BoomboxScreen extends OEItemBEContainerBasedScreen<BoomboxMenu> {
    public static final class_2960 BG_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/boombox/boombox_base.png");
    public static final class_2960 EMPTY_CASSETTE_TAPE_SLOT = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/slot/cassette_tape_slot.png");
    public static final class_2960 EMPTY_ANTENNA_SLOT = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/slot/antenna_slot.png");
    private final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<>();
    protected BoomboxMonitor monitor;
    public long lastNoAntenna;

    public BoomboxScreen(BoomboxMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 214;
        this.field_2779 = 175;
        this.field_25270 = this.field_2779 - 94;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new BoomboxButton(field_2776 + 5, field_2800 + 17, BoomboxData.ButtonType.POWER, n -> {
            insPressButton(BoomboxData.ButtonType.POWER);
        }, this::getButtons, this::isPowered));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19, field_2800 + 17, BoomboxData.ButtonType.RADIO, n -> {
            if (!getAntenna().method_7960() && IMPItemUtil.isAntenna(getAntenna())) {
                insPressButton(BoomboxData.ButtonType.RADIO);
            } else {
                lastNoAntenna = System.currentTimeMillis();
            }
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 2, field_2800 + 17, BoomboxData.ButtonType.START, n -> {
            insPressButton(BoomboxData.ButtonType.START);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 3, field_2800 + 17, BoomboxData.ButtonType.PAUSE, n -> {
            insPressButton(BoomboxData.ButtonType.PAUSE);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 4, field_2800 + 17, BoomboxData.ButtonType.STOP, n -> {
            insPressButton(BoomboxData.ButtonType.STOP);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 5, field_2800 + 17, BoomboxData.ButtonType.LOOP, n -> {
            insPressButton(BoomboxData.ButtonType.LOOP);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 6 + 14, field_2800 + 17, BoomboxData.ButtonType.VOL_DOWN, n -> {
            insPressButton(BoomboxData.ButtonType.VOL_DOWN);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 7 + 14, field_2800 + 17, BoomboxData.ButtonType.VOL_UP, n -> {
            insPressButton(BoomboxData.ButtonType.VOL_UP);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 8 + 14, field_2800 + 17, BoomboxData.ButtonType.VOL_MUTE, n -> {
            insPressButton(BoomboxData.ButtonType.VOL_MUTE);
        }, this::getButtons));

        this.method_37063(new BoomboxButton(field_2776 + 5 + 19 * 9 + 14, field_2800 + 17, BoomboxData.ButtonType.VOL_MAX, n -> {
            insPressButton(BoomboxData.ButtonType.VOL_MAX);
        }, this::getButtons));

        changeScreenMonitor(getRawMonitorType());
    }

    @Override
    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
    }

    @Override
    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
        super.method_2389(poseStack, f, i, j);
        if (getCassetteTape().method_7960())
            OERenderUtils.drawTexture(EMPTY_CASSETTE_TAPE_SLOT, poseStack, field_2776 + 183, field_2800 + 98, 0, 0, 16, 16, 16, 16);
        if (getAntenna().method_7960())
            OERenderUtils.drawTexture(EMPTY_ANTENNA_SLOT, poseStack, field_2776 + 183, field_2800 + 124, 0, 0, 16, 16, 16, 16);

        if (monitor != null)
            monitor.render(poseStack, f, i, j);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (monitor != null) {
            if (getRawMonitorType() != monitor.getType())
                changeScreenMonitor(getRawMonitorType());
            monitor.tick();
        }
    }

    public void insSelectedPlayList(@Nullable UUID uuid) {
        var tag = new class_2487();
        if (uuid != null)
            tag.method_25927("pl", uuid);
        instruction("set_selected_play_list", tag);
    }

    public void insRadioUrl(String url) {
        var tag = new class_2487();
        tag.method_10582("url", url);
        instruction("set_radio_url", tag);
    }

    public void insSelectedMusic(@Nullable UUID musicId) {
        var tag = new class_2487();
        if (musicId != null)
            tag.method_25927("m", musicId);
        instruction("set_selected_music", tag);
    }

    public boolean isMute() {
        return getBoomBoxData().isMute();
    }

    public boolean isPlaying() {
        return getBoomBoxData().isPlaying();
    }

    public int getVolume() {
        return getBoomBoxData().getVolume();
    }

    public long getMusicPosition() {
        return getBoomBoxData().getMusicPosition();
    }

    private boolean isPowered() {
        return getBoomBoxData().isPowered();
    }

    public boolean isLoop() {
        return getBoomBoxData().isLoop();
    }

    public BoomboxData getBoomBoxData() {
        if (isBlock()) {
            if (getBlockEntity() instanceof BoomboxBlockEntity boomboxBlockEntity)
                return boomboxBlockEntity.getBoomboxData();
        }
        return BoomboxItem.getData(getItem());
    }

    public void insMonitor(BoomboxData.MonitorType monitorType) {
        var tag = new class_2487();
        tag.method_10582("name", monitorType.getName());
        instruction("set_monitor", tag);
    }

    public boolean isMusicLoading() {
        return getBoomBoxData().isLoadingMusic();
    }

    public class_1799 getCassetteTape() {
        return method_17577().method_7602().get(0);
    }

    public class_1799 getAntenna() {
        return method_17577().method_7602().get(1);
    }

    public void insVolume(int volume) {
        var tag = new class_2487();
        tag.method_10569("volume", volume);
        instruction("set_volume", tag);
    }

    public void insPositionAndRestart(long position) {
        var tag = new class_2487();
        tag.method_10544("position", position);
        instruction("restat_and_set_position", tag);
    }

    public void insContinuousType(@NotNull BoomboxData.ContinuousType continuousType) {
        var tag = new class_2487();
        tag.method_10582("type", continuousType.getName());
        instruction("set_continuous_type", tag);
    }

    public void insLoop(boolean loop) {
        var tag = new class_2487();
        tag.method_10556("loop", loop);
        instruction("set_loop", tag);
    }

    public void insPause() {
        instruction("set_pause", new class_2487());
    }

    public void insPlaying(boolean playing) {
        var tag = new class_2487();
        tag.method_10556("playing", playing);
        instruction("set_playing", tag);
    }

    public void insRadioSource(MusicSource source) {
        var tag = new class_2487();
        tag.method_10566("source", source.createSavedTag());
        instruction("set_radio_source", tag);
    }

    public void insRadioImage(ImageInfo imageInfo) {
        var tag = new class_2487();
        tag.method_10566("image", imageInfo.createSavedTag());
        instruction("set_radio_image", tag);
    }

    public void insRadioName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_radio_name", tag);
    }

    public void insRadioAuthor(String author) {
        var tag = new class_2487();
        tag.method_10582("author", author);
        instruction("set_radio_author", tag);
    }

    @Override
    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    private BoomboxData.Buttons getButtons() {
        return getBoomBoxData().getButtons();
    }

    private void insPressButton(BoomboxData.ButtonType type) {
        var tag = new class_2487();
        tag.method_10582("Type", type.getName());
        instruction("buttons_press", tag);
    }

    private void changeScreenMonitor(BoomboxData.MonitorType type) {
        if (monitor != null) {
            monitor.renderables.forEach(this::method_37066);
            monitor.depose();
        }

        if (!monitors.containsKey(type))
            monitors.put(type, BoomboxMonitor.createdBoomBoxMonitor(type, this));

        monitor = monitors.get(type);
        monitor.init(field_2776, field_2800);
        monitor.renderables.forEach(this::method_37063);
    }

    private BoomboxData.MonitorType getRawMonitorType() {
        return getBoomBoxData().getMonitorType();
    }

    @Override
    public void method_25419() {
        super.method_25419();
        if (monitor != null)
            monitor.depose();
    }

    @Override
    public void method_29638(List<Path> list) {
        if (monitor != null)
            monitor.onFilesDrop(list);
    }

}
