package dev.felnull.imp.client.music.media;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * 音楽の再生メディア
 */
public interface MusicMedia {
    class_2561 getMediaName();

    class_2561 getEnterText();

    class_2960 getIcon();

    boolean isSearchable();

    MusicMediaResult load(String sourceName) throws Exception;

    default List<MusicMediaResult> search(String searchText) {
        return new ArrayList<>();
    }

    default String getName() {
        for (Map.Entry<String, MusicMedia> entry : IMPMusicMedias.MEDIAS.entrySet()) {
            if (entry.getValue().equals(this))
                return entry.getKey();
        }
        return null;
    }
}
