package dev.felnull.imp.music;

import dev.felnull.otyacraftengine.util.OENbtUtils;
import net.minecraft.class_2487;

/**
 * スピーカー固定情報
 *
 * @param channel     チャンネル数(-1で全チャンネル) 0=L 1=R
 * @param spatialType 空間的な再生かどうか
 */
public record MusicSpeakerFixedInfo(int channel, SpatialType spatialType) {
    public MusicSpeakerFixedInfo() {
        this(-1, SpatialType.ENTRUST);
    }

    public class_2487 toTag() {
        var tag = new class_2487();
        tag.method_10569("channel", channel);
        OENbtUtils.writeEnumByOrdinal(tag, "spatial_type", spatialType);
        return tag;
    }

    public static MusicSpeakerFixedInfo loadByTag(class_2487 tag) {
        int channel = tag.method_10550("channel");
        var spatialType = OENbtUtils.readEnumByOrdinal(tag, "spatial_type", SpatialType.class, SpatialType.ENTRUST);
        return new MusicSpeakerFixedInfo(channel, spatialType);
    }
}
