package dev.felnull.imp.music;

import dev.felnull.imp.api.MusicSpeakerInfoAccess;
import dev.felnull.imp.client.util.MusicUtils;
import net.minecraft.class_243;
import net.minecraft.class_2487;

/**
 * 音楽が流れるスピーカー情報
 *
 * @param position  スピーカーの場所
 * @param volume    ボリューム
 * @param range     範囲
 * @param fixedInfo 固定情報
 */
public record MusicSpeakerInfo(class_243 position, float volume, float range,
                               MusicSpeakerFixedInfo fixedInfo) implements MusicSpeakerInfoAccess {
    public MusicSpeakerInfo() {
        this(class_243.field_1353, 0, 0, new MusicSpeakerFixedInfo());
    }

    public class_2487 toTag() {
        var tag = new class_2487();

        tag.method_10549("x", position.field_1352);
        tag.method_10549("y", position.field_1351);
        tag.method_10549("z", position.field_1350);

        tag.method_10548("volume", volume);
        tag.method_10548("range", range);

        tag.method_10566("fixed_info", fixedInfo.toTag());

        return tag;
    }

    public static MusicSpeakerInfo loadByTag(class_2487 tag) {
        var position = new class_243(tag.method_10574("x"), tag.method_10574("y"), tag.method_10574("z"));

        float volume = tag.method_10583("volume");
        float range = tag.method_10583("range");

        var fixedInfo = MusicSpeakerFixedInfo.loadByTag(tag.method_10562("fixed_info"));

        return new MusicSpeakerInfo(position, volume, range, fixedInfo);
    }

    @Override
    public class_243 getPosition() {
        return position;
    }

    @Override
    public float getVolume() {
        return volume;
    }

    @Override
    public float getRange() {
        return range;
    }

    @Override
    public int getChannel() {
        return fixedInfo().channel();
    }

    @Override
    public boolean isSpatial() {
        return MusicUtils.isSpatial(fixedInfo.spatialType());
    }
}
