package dev.felnull.imp.block;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntities;
import dev.felnull.otyacraftengine.shape.bundle.DirectionVoxelShapesBundle;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtils;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class CassetteDeckBlock extends IMPBaseEntityBlock {
    private static final DirectionVoxelShapesBundle SHAPE = OEVoxelShapeUtils.makeAllDirection(OEVoxelShapeUtils.getShapeFromResource(new class_2960(IamMusicPlayer.MODID, "cassette_deck"), BoomboxBlock.class));

    protected CassetteDeckBlock(class_2251 properties) {
        super(properties);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new CassetteDeckBlockEntity(blockPos, blockState);
    }

    @Override
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return SHAPE.getShape(blockState.method_11654(FACING));
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return method_31618(blockEntityType, IMPBlockEntities.CASSETTE_DECK.get(), CassetteDeckBlockEntity::tick);
    }
}
