package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class RemoteMusicsFixedListWidget extends MusicsFixedListWidget {
    public RemoteMusicsFixedListWidget(int x, int y, List<Music> list, PressEntry<Music> onPressEntry, @Nullable RemoteMusicsFixedListWidget old) {
        super(x, y, 129, 35, class_2561.method_43471("imp.fixedList.myMusic"), 5, list, onPressEntry, false, old);
    }

    @Override
    protected void renderOneButton(class_332 guiGraphics, Music item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        drawSmartButtonBox(guiGraphics, bX, bY, getIndividualWidth(), getIndividualHeight(), this.getYImage(this.isEntryHovered(bnum)));

        float sx = 1;
        var img = item.getImage();
        if (!img.isEmpty()) {
            sx += getIndividualHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, guiGraphics.method_51448(), bX + 1, bY + 1, getIndividualHeight() - 2);
        }

        guiGraphics.method_51448().method_22903();
        float sc = 0.7f;
        OERenderUtils.poseScaleAll(guiGraphics.method_51448(), sc);
        drawSmartText(guiGraphics, class_2561.method_43470(OEClientUtils.getWidthOmitText(item.getName(), getIndividualWidth() - sx - 2 + 47, "...")), (bX + sx) / sc, (bY + 1f) / sc);
        guiGraphics.method_51448().method_22909();
    }
}
