package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class SmartButton extends IMPButton implements IIMPSmartRender {
    private boolean center = true;
    private class_2960 iconTexture;
    private int iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight;
    private boolean hideText;

    public void setCenter(boolean center) {
        this.center = center;
    }

    public SmartButton(int x, int y, int w, int h, class_2561 text, class_4241 onPress) {
        super(x, y, w, h, text, onPress);
    }

    public void setHideText(boolean hideText) {
        this.hideText = hideText;
    }

    protected int getYImage(boolean bl) {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (bl) {
            i = 2;
        }

        return i;
    }


    @Override
    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        drawSmartButtonBox(guiGraphics, method_46426(), method_46427(), field_22758, field_22759, this.getYImage(this.method_25367()));
        float fx = center ? (float) (field_22758 - mc.field_1772.method_27525(method_25369())) / 2f : 2;
        float fy = (float) (field_22759 - 7) / 2f;

        if (iconTexture != null) {
            float itx = hideText ? (field_22758 - iconWidth) / 2f : 2;
            float ity = (float) (field_22759 - iconHeight) / 2f;
            fx += itx + iconWidth;
            OERenderUtils.drawTexture(iconTexture, guiGraphics.method_51448(), method_46426() + itx, method_46427() + ity, iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight);
        }

        if (!hideText)
            drawSmartText(guiGraphics, method_25369(), method_46426() + fx, method_46427() + fy);

        /*if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, mx, my);*/
    }

    public void setIcon(class_2960 location, int stX, int stY, int w, int h) {
        setIcon(location, stX, stY, w, h, 256, 256);
    }

    public void setIcon(class_2960 location, int stX, int stY, int w, int h, int texW, int texH) {
        setCenter(false);
        this.iconTexture = location;
        this.iconStX = stX;
        this.iconStY = stY;
        this.iconWidth = w;
        this.iconHeight = h;
        this.textureWidth = texW;
        this.textureHeight = texH;
    }

}
