package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public abstract class SortButton extends IMPButton implements IIMPSmartRender {
    protected final boolean longed;

    private SortButton(int x, int y, int w, int tx, class_2561 component, class_4241 onPress, boolean longed, class_437 screen) {
        super(x, y, w, 9, component, onPress);
        // super(x, y, w, 9, component, onPress, longed ? NO_TOOLTIP : (button, poseStack, px, py) -> screen.renderTooltip(poseStack, getText(button), px, py));
        // super(x, y, w, 9, tx, 30, 9, MusicManagerMonitor.WIDGETS_TEXTURE, 256, 256, onPress, longed ? NO_TOOLTIP : (button, poseStack, px, py) -> screen.renderTooltip(poseStack, getText(button), px, py), Component.translatable("imp.button.sort"));
        this.longed = longed;
    }

    @Override
    public void method_25306() {
        cycle();
        method_47400(class_7919.method_47407(getToolTipComponent()));
        super.method_25306();
    }

    @Override
    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        drawSmartButtonBox(guiGraphics, method_46426(), method_46427(), field_22758, field_22759, method_25367());
      /*  if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, mx, my);*/
    }

    abstract public void cycle();

    abstract public class_2561 getToolTipComponent();

    public static enum SortType {
        NAME("name", (o1, o2) -> {
            return o1.getCompareName().compareTo(o2.getCompareName());
        }), PLAYER("player", (o1, o2) -> {
            return o1.getComparePlayerName().compareTo(o2.getComparePlayerName());
        }), CREATE_DATE("create_date", (o1, o2) -> (int) (o1.getCompareDate() - o2.getCompareDate()));
        private final String name;
        private final Comparator<IIMPComparable> comparator;
        private final Comparator<IIMPComparable> rcomparator;
        private final class_2561 componentName;

        SortType(String name, Comparator<IIMPComparable> comparator) {
            this.name = name;
            this.comparator = comparator;
            this.rcomparator = comparator.reversed();
            this.componentName = class_2561.method_43471("imp.sortType." + name);
        }

        public String getName() {
            return name;
        }

        public Comparator<IIMPComparable> getComparator(OrderType orderType) {
            return orderType.isReverse() ? rcomparator : comparator;
        }

        public class_2561 getComponentName() {
            return componentName;
        }
    }

    public static enum OrderType {
        ASCENDING("ascending", false), DESCENDING("descending", true);
        private final String name;
        private final boolean reverse;
        private final class_2561 componentName;

        OrderType(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
            this.componentName = class_2561.method_43471("imp.orderType." + name);
        }

        public boolean isReverse() {
            return reverse;
        }

        public String getName() {
            return name;
        }

        public class_2561 getComponentName() {
            return componentName;
        }
    }

    public static class SortTypeButton extends SortButton {
        private SortType type = SortType.NAME;

        public SortTypeButton(int x, int y, class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 97 : 9, longed ? 61 : 52, class_2561.method_43471("imp.button.sort"), onPress, longed, screen);
            if (!longed)
                method_47400(class_7919.method_47407(getToolTipComponent()));
        }

        @Override
        public void cycle() {
            type = SortType.values()[(type.ordinal() + 1) % SortType.values().length];
        }

        @Override
        public class_2561 getToolTipComponent() {
            return type.getComponentName();
        }

        public SortType getSortType() {
            return type;
        }

        public <T extends IIMPComparable> List<T> sort(List<T> target, OrderTypeButton orderTypeButton) {
            return target.stream().sorted(getSortType().getComparator(orderTypeButton.getOrderType())).toList();
        }

        @Override
        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            super.method_48579(guiGraphics, i, j, f);
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.method_51448(), method_46426() + 1, method_46427() + 1, 73 + getSortType().ordinal() * 7, 0, 7, 7);
            if (longed) {
                drawSmartText(guiGraphics, getToolTipComponent(), method_46426() + 9, method_46427() + 1);
            }
        }
    }

    public static class OrderTypeButton extends SortButton {
        private OrderType type = OrderType.DESCENDING;

        public OrderTypeButton(int x, int y, class_4241 onPress, boolean longed, class_437 screen) {
            super(x, y, longed ? 88 : 9, longed ? 158 : 52, class_2561.method_43471("imp.button.order"), onPress, longed, screen);
            if (!longed)
                method_47400(class_7919.method_47407(getToolTipComponent()));
        }

        @Override
        public void cycle() {
            type = OrderType.values()[(type.ordinal() + 1) % OrderType.values().length];
        }

        @Override
        public class_2561 getToolTipComponent() {
            return type.getComponentName();
        }

        public OrderType getOrderType() {
            return type;
        }

        @Override
        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            super.method_48579(guiGraphics, i, j, f);
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.method_51448(), method_46426() + 1, method_46427() + 1, 73 + getOrderType().ordinal() * 7, 7, 7, 7);
            if (longed) {
                drawSmartText(guiGraphics, getToolTipComponent(), method_46426() + 9, method_46427() + 1);
            }
        }
    }
}
