package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class CassetteDeckScreen extends IMPBaseContainerScreen<CassetteDeckMenu> {
    public static final class_2960 BG_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/cassette_deck/cassette_deck_base.png");
    public static final class_2960 EMPTY_CASSETTE_TAPE_SLOT = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/slot/cassette_tape_slot.png");
    private final Map<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor> monitors = new HashMap<>();
    protected CassetteDeckMonitor monitor;

    public CassetteDeckScreen(CassetteDeckMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 214;
        this.field_2779 = 176;
        this.field_25270 = this.field_2779 - 94;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new PowerButton(this, field_2776 + 185, field_2800 + 79, 12, 12, 214, 0, BG_TEXTURE, bgTextureWidth, bgTextureHeight));


        changeScreenMonitor(getRawMonitorType());
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float f, int i, int j) {
        super.method_2389(guiGraphics, f, i, j);
        if (getCassetteTape().method_7960())
            OERenderUtils.drawTexture(EMPTY_CASSETTE_TAPE_SLOT, guiGraphics.method_51448(), field_2776 + 183, field_2800 + 99, 0, 0, 16, 16, 16, 16);

        if (monitor != null)
            monitor.render(guiGraphics, f, i, j);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (monitor != null) {
            if (getRawMonitorType() != monitor.getType())
                changeScreenMonitor(getRawMonitorType());
            monitor.tick();
        }
    }

    public long getPosition() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return getPosition(cassetteDeckBlockEntity);
        return 0;
    }

    public long getPosition(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getPosition();
    }

    public boolean isPlaying() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isPlaying(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isPlaying(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isPlaying();
    }

    public void insPositionAndRestart(long position) {
        var tag = new class_2487();
        tag.method_10544("position", position);
        instruction("restat_and_set_position", tag);
    }


    public void insLoop(boolean loop) {
        var tag = new class_2487();
        tag.method_10556("loop", loop);
        instruction("set_loop", tag);
    }

    public boolean isLoop() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isLoop(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isLoop(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoop();
    }

    private void changeScreenMonitor(CassetteDeckBlockEntity.MonitorType type) {
        if (monitor != null) {
            monitor.renderables.forEach(this::method_37066);
            monitor.depose();
        }

        if (!monitors.containsKey(type))
            monitors.put(type, CassetteDeckMonitor.createdCassetteDeckMonitor(type, this));

        monitor = monitors.get(type);
        monitor.init(field_2776, field_2800);
        monitor.renderables.forEach(this::method_37063);
    }

    public void insPause() {
        instruction("set_pause", new class_2487());
    }

    public void insPlaying(boolean playing) {
        var tag = new class_2487();
        tag.method_10556("playing", playing);
        instruction("set_playing", tag);
    }

    public void insVolume(int volume) {
        var tag = new class_2487();
        tag.method_10569("volume", volume);
        instruction("set_volume", tag);
    }

    public void insMute(boolean mute) {
        var tag = new class_2487();
        tag.method_10556("mute", mute);
        instruction("set_mute", tag);
    }

    public void insMonitor(CassetteDeckBlockEntity.MonitorType monitorType) {
        var tag = new class_2487();
        tag.method_10582("name", monitorType.getName());
        instruction("monitor", tag);
    }

    public void insSelectPlaylist(UUID uuid) {
        var tag = new class_2487();
        tag.method_25927("uuid", uuid);
        instruction("select_playlist", tag);
    }

    public void insMusic(UUID uuid) {
        var tag = new class_2487();
        tag.method_25927("music", uuid);
        instruction("set_music", tag);
    }

    public CassetteDeckBlockEntity.MonitorType getRawMonitorType() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return cassetteDeckBlockEntity.getMonitor();
        return CassetteDeckBlockEntity.MonitorType.OFF;
    }

    public class_1799 getCassetteTape() {
        return method_17577().method_7602().get(0);
    }

    public boolean isLoading() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isLoading(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isLoading(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoadingMusic();
    }

    public int getVolume() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return getVolume(cassetteDeckBlockEntity);
        return 0;
    }

    public int getVolume(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getVolume();
    }

    public boolean isMute() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isMute(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isMute(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isMute();
    }

    @Override
    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        if (monitor != null)
            monitor.depose();
    }

    @Override
    public void method_29638(List<Path> list) {
        if (monitor != null)
            monitor.onFilesDrop(list);
    }
}
